/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.http;

import datadog.trace.api.Config;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.common.socket.NamedPipeSocketFactory;
import ddtrot.dd.common.socket.SocketUtils;
import ddtrot.dd.common.socket.UnixDomainSocketFactory;
import ddtrot.dd.communication.http.RejectingExecutorService;
import ddtrot.dd.trace.util.AgentProxySelector;
import ddtrot.okhttp3.ConnectionPool;
import ddtrot.okhttp3.ConnectionSpec;
import ddtrot.okhttp3.Credentials;
import ddtrot.okhttp3.Dispatcher;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.MediaType;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okio.BufferedSink;
import ddtrot.okio.GzipSink;
import ddtrot.okio.Okio;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String DD_API_KEY = "DD-API-KEY";
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String JAVA_VM_NAME = System.getProperty("java.vm.name", "unknown");
    private static final String JAVA_VM_VENDOR = System.getProperty("java.vm.vendor", "unknown");

    public static OkHttpClient buildHttpClient(HttpUrl url, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(url, null, null, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(HttpUrl url, String unixDomainSocketPath, String namedPipe, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(unixDomainSocketPath, namedPipe, null, url, null, null, null, null, null, null, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(Config config, Dispatcher dispatcher, HttpUrl url, Boolean retryOnConnectionFailure, Integer maxRunningRequests, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(SocketUtils.discoverApmSocket(config), config.getAgentNamedPipe(), dispatcher, url, retryOnConnectionFailure, maxRunningRequests, proxyHost, proxyPort, proxyUsername, proxyPassword, timeoutMillis);
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath, String namedPipe, Dispatcher dispatcher, HttpUrl url, Boolean retryOnConnectionFailure, Integer maxRunningRequests, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, long timeoutMillis) {
        boolean isHttp;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).proxySelector(AgentProxySelector.INSTANCE).dispatcher(dispatcher != null ? dispatcher : new Dispatcher(RejectingExecutorService.INSTANCE));
        if (unixDomainSocketPath != null) {
            builder.socketFactory(new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
            log.debug("Using UnixDomainSocket as http transport");
        } else if (namedPipe != null) {
            builder.socketFactory(new NamedPipeSocketFactory(namedPipe));
            log.debug("Using NamedPipe as http transport");
        }
        boolean bl = isHttp = url != null && "http".equals(url.scheme());
        if (isHttp) {
            builder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
        }
        if (retryOnConnectionFailure != null) {
            builder.retryOnConnectionFailure(retryOnConnectionFailure);
        }
        if (maxRunningRequests != null) {
            builder.connectionPool(new ConnectionPool(maxRunningRequests, 1L, TimeUnit.SECONDS));
        }
        if (proxyHost != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort)));
            if (proxyUsername != null) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic(proxyUsername, proxyPassword == null ? "" : proxyPassword);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        OkHttpClient client = builder.build();
        if (maxRunningRequests != null) {
            client.dispatcher().setMaxRequests(maxRunningRequests);
            client.dispatcher().setMaxRequestsPerHost(maxRunningRequests);
        }
        return client;
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, JAVA_VM_VENDOR);
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId != null) {
            builder.addHeader(DATADOG_CONTAINER_ID, containerId);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            builder.addHeader(e.getKey(), e.getValue());
        }
        return builder;
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> headers, Config config, boolean agentless) {
        Request.Builder builder = OkHttpUtils.prepareRequest(url, headers);
        String apiKey = config.getApiKey();
        if (agentless && apiKey != null) {
            builder = builder.addHeader(DD_API_KEY, apiKey);
        }
        return builder;
    }

    public static RequestBody msgpackRequestBodyOf(List<ByteBuffer> buffers) {
        return new ByteBufferRequestBody(buffers);
    }

    public static RequestBody gzippedMsgpackRequestBodyOf(List<ByteBuffer> buffers) {
        return new GZipByteBufferRequestBody(buffers);
    }

    private static final class GZipByteBufferRequestBody
    extends ByteBufferRequestBody {
        private GZipByteBufferRequestBody(List<ByteBuffer> buffers) {
            super(buffers);
        }

        @Override
        public long contentLength() {
            return -1L;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            BufferedSink gzipSink = Okio.buffer(new GzipSink(sink));
            super.writeTo(gzipSink);
            gzipSink.close();
        }
    }

    private static class ByteBufferRequestBody
    extends RequestBody {
        private static final MediaType MSGPACK = MediaType.get("application/msgpack");
        private final List<ByteBuffer> buffers;

        private ByteBufferRequestBody(List<ByteBuffer> buffers) {
            this.buffers = buffers;
        }

        @Override
        public long contentLength() {
            long length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                length += (long)buffer.remaining();
            }
            return length;
        }

        @Override
        public MediaType contentType() {
            return MSGPACK;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            for (ByteBuffer buffer : this.buffers) {
                while (buffer.hasRemaining()) {
                    sink.write(buffer);
                }
            }
        }
    }
}

