/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import ddtrot.dd.trace.api.iast.telemetry.Verbosity;
import de.thetaphi.forbiddenapis.SuppressForbidden;

public enum IastMetric {
    INSTRUMENTED_PROPAGATION("instrumented.propagation", true, Scope.GLOBAL, Verbosity.MANDATORY),
    INSTRUMENTED_SOURCE_REQUEST_PARAMETER_NAME("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.parameter.name"),
    INSTRUMENTED_SOURCE_REQUEST_PARAMETER_VALUE("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.parameter"),
    INSTRUMENTED_SOURCE_REQUEST_HEADER_NAME("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.header.name"),
    INSTRUMENTED_SOURCE_REQUEST_HEADER_VALUE("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.header"),
    INSTRUMENTED_SOURCE_REQUEST_COOKIE_NAME("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.cookie.name"),
    INSTRUMENTED_SOURCE_REQUEST_COOKIE_VALUE("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.cookie.value"),
    INSTRUMENTED_SOURCE_REQUEST_REQUEST_BODY("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.body"),
    INSTRUMENTED_SOURCE_REQUEST_QUERY("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.query"),
    INSTRUMENTED_SOURCE_REQUEST_PATH_PARAMETER("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.path.parameter"),
    INSTRUMENTED_SOURCE_REQUEST_MATRIX_PARAMETER("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type", "http.request.matrix.parameter"),
    INSTRUMENTED_SINK_WEAK_CIPHER("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "WEAK_CIPHER"),
    INSTRUMENTED_SINK_WEAK_HASH("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "WEAK_HASH"),
    INSTRUMENTED_SINK_SQL_INJECTION("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "SQL_INJECTION"),
    INSTRUMENTED_SINK_COMMAND_INJECTION("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "COMMAND_INJECTION"),
    INSTRUMENTED_SINK_PATH_TRAVERSAL("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "PATH_TRAVERSAL"),
    INSTRUMENTED_SINK_LDAP_INJECTION("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "LDAP_INJECTION"),
    INSTRUMENTED_SINK_SSRF("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "SSRF"),
    INSTRUMENTED_SINK_INSECURE_COOKIE("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "INSECURE_COOKIE"),
    INSTRUMENTED_SINK_UNVALIDATED_REDIRECT("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "INSECURE_COOKIE"),
    INSTRUMENTED_SINK_WEAK_RANDOMNESS("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type", "WEAK_RANDOMNESS"),
    EXECUTED_PROPAGATION("executed.propagation", true, Scope.REQUEST, Verbosity.DEBUG),
    EXECUTED_SOURCE_REQUEST_PARAMETER_NAME("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.parameter.name"),
    EXECUTED_SOURCE_REQUEST_PARAMETER_VALUE("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.parameter"),
    EXECUTED_SOURCE_REQUEST_HEADER_NAME("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.header.name"),
    EXECUTED_SOURCE_REQUEST_HEADER_VALUE("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.header"),
    EXECUTED_SOURCE_REQUEST_COOKIE_NAME("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.cookie.name"),
    EXECUTED_SOURCE_REQUEST_COOKIE_VALUE("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.cookie.value"),
    EXECUTED_SOURCE_REQUEST_REQUEST_BODY("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.body"),
    EXECUTED_SOURCE_REQUEST_QUERY("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.query"),
    EXECUTED_SOURCE_REQUEST_PATH_PARAMETER("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.path.parameter"),
    EXECUTED_SOURCE_REQUEST_MATRIX_PARAMETER("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type", "http.request.matrix.parameter"),
    EXECUTED_SINK_WEAK_CIPHER("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "WEAK_CIPHER"),
    EXECUTED_SINK_WEAK_HASH("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "WEAK_HASH"),
    EXECUTED_SINK_SQL_INJECTION("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "SQL_INJECTION"),
    EXECUTED_SINK_COMMAND_INJECTION("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "COMMAND_INJECTION"),
    EXECUTED_SINK_PATH_TRAVERSAL("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "PATH_TRAVERSAL"),
    EXECUTED_SINK_LDAP_INJECTION("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "LDAP_INJECTION"),
    EXECUTED_SINK_SSRF("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "SSRF"),
    EXECUTED_SINK_INSECURE_COOKIE("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "INSECURE_COOKIE"),
    EXECUTED_SINK_UNVALIDATED_REDIRECT("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "INSECURE_COOKIE"),
    EXECUTED_SINK_WEAK_RANDOMNESS("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type", "WEAK_RANDOMNESS"),
    EXECUTED_TAINTED("executed.tainted", true, Scope.REQUEST, Verbosity.DEBUG),
    REQUEST_TAINTED("request.tainted", true, Scope.REQUEST, Verbosity.INFORMATION),
    TAINTED_FLAT_MODE("tainted.flat.mode", false, Scope.REQUEST, Verbosity.INFORMATION);

    private final String name;
    private final boolean common;
    private final Scope scope;
    private final String tagName;
    private final String tagValue;
    private final Verbosity verbosity;

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity) {
        this(name, common, scope, verbosity, null, null);
    }

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity, String tagName, String tagValue) {
        this.name = name;
        this.common = common;
        this.scope = scope;
        this.verbosity = verbosity;
        this.tagName = tagName;
        this.tagValue = tagValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCommon() {
        return this.common;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getTag() {
        return this.tagName == null ? null : String.format("%s:%s", this.tagName, this.tagValue);
    }

    public String getSpanTag() {
        return this.tagName == null ? null : String.format("%s.%s", this.name, IastMetric.processTagValue(this.tagValue));
    }

    @SuppressForbidden
    private static String processTagValue(String tagValue) {
        return tagValue.toLowerCase().replaceAll("\\.", "_");
    }

    public boolean isEnabled(Verbosity verbosity) {
        return verbosity.isEnabled(this.verbosity);
    }

    private static class MetricNames {
        public static final String INSTRUMENTED_PROPAGATION = "instrumented.propagation";
        public static final String INSTRUMENTED_SOURCE = "instrumented.source";
        public static final String INSTRUMENTED_SINK = "instrumented.sink";
        public static final String EXECUTED_PROPAGATION = "executed.propagation";
        public static final String EXECUTED_SOURCE = "executed.source";
        public static final String EXECUTED_SINK = "executed.sink";
        public static final String EXECUTED_TAINTED = "executed.tainted";
        public static final String REQUEST_TAINTED = "request.tainted";
        public static final String TAINTED_FLAT_MODE = "tainted.flat.mode";

        private MetricNames() {
        }
    }

    public static enum Scope {
        GLOBAL,
        REQUEST;

    }

    public static abstract class Tags {
        public static final String VULNERABILITY_TYPE = "vulnerability_type";
        public static final String SOURCE_TYPE = "source_type";

        private Tags() {
        }
    }
}

