/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.iast.telemetry.IastMetric;
import ddtrot.dd.trace.api.iast.telemetry.Verbosity;
import ddtrot.dd.trace.api.telemetry.MetricCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IastMetricCollector
implements MetricCollector<IastMetricData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IastMetricCollector.class);
    private static final IastMetricCollector INSTANCE = IastMetricCollector.isEnabled() ? new IastMetricCollector() : new NoOpInstance();
    private static final String NAMESPACE = "iast";
    private final BlockingQueue<IastMetricData> rawMetricsQueue;
    private final AtomicLongArray counters;

    public static IastMetricCollector get() {
        return INSTANCE;
    }

    public static IastMetricCollector get(@Nonnull IastMetric metric, @Nullable RequestContext ctx) {
        Object iastCtx;
        if (metric.getScope() == IastMetric.Scope.REQUEST && (ctx = IastMetricCollector.activeRequestContext(ctx)) != null && (iastCtx = ctx.getData(RequestContextSlot.IAST)) instanceof HasTelemetryCollector) {
            return ((HasTelemetryCollector)iastCtx).getTelemetryCollector();
        }
        return IastMetricCollector.get();
    }

    public IastMetricCollector() {
        this(new ArrayBlockingQueue<IastMetricData>(1024), new AtomicLongArray(IastMetric.values().length));
    }

    protected IastMetricCollector(BlockingQueue<IastMetricData> rawMetricsQueue, AtomicLongArray counters) {
        this.rawMetricsQueue = rawMetricsQueue;
        this.counters = counters;
    }

    public static void add(@Nonnull IastMetric metric, long value) {
        IastMetricCollector.add(metric, value, null);
    }

    public static void add(@Nonnull IastMetric metric, long value, @Nullable RequestContext ctx) {
        try {
            IastMetricCollector instance = IastMetricCollector.get(metric, ctx);
            instance.addMetric(metric, value);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to add metric {}", (Object)metric, (Object)e);
        }
    }

    public void addMetric(IastMetric metric, long value) {
        this.counters.addAndGet(metric.ordinal(), value);
    }

    public void merge(Collection<IastMetricData> metrics) {
        for (IastMetricData data : metrics) {
            IastMetric metric = data.metric;
            long value = data.counter;
            this.counters.addAndGet(metric.ordinal(), value);
        }
    }

    @Override
    public void prepareMetrics() {
        for (IastMetric metric : IastMetric.values()) {
            long value = this.counters.getAndSet(metric.ordinal(), 0L);
            if (value <= 0L) continue;
            this.rawMetricsQueue.offer(new IastMetricData(metric, value));
        }
    }

    @Override
    public Collection<IastMetricData> drain() {
        LinkedList<IastMetricData> list;
        int drained;
        if (!this.rawMetricsQueue.isEmpty() && (drained = this.rawMetricsQueue.drainTo(list = new LinkedList<IastMetricData>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    private static RequestContext activeRequestContext(RequestContext context) {
        if (context != null) {
            return context;
        }
        AgentSpan span = AgentTracer.activeSpan();
        return span == null ? null : span.getRequestContext();
    }

    private static boolean isEnabled() {
        Config config = Config.get();
        return config.isTelemetryEnabled() && config.getIastTelemetryVerbosity() != Verbosity.OFF;
    }

    public static interface HasTelemetryCollector {
        public IastMetricCollector getTelemetryCollector();
    }

    private static class NoOpInstance
    extends IastMetricCollector {
        public NoOpInstance() {
            super(null, null);
        }

        @Override
        public void addMetric(IastMetric metric, long value) {
        }

        @Override
        public void merge(Collection<IastMetricData> metrics) {
        }

        @Override
        public void prepareMetrics() {
        }

        @Override
        public Collection<IastMetricData> drain() {
            return Collections.emptyList();
        }
    }

    public static class IastMetricData
    extends MetricCollector.Metric {
        public final IastMetric metric;

        public IastMetricData(IastMetric metric, long value) {
            super(IastMetricCollector.NAMESPACE, metric.isCommon(), metric.getName(), value, metric.getTag());
            this.metric = metric;
        }
    }
}

