/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import java.util.function.Supplier;

public class TagContextExtractor
implements HttpCodec.Extractor {
    private final Supplier<TraceConfig> traceConfigSupplier;
    private final ThreadLocal<ContextInterpreter> ctxInterpreter;

    public TagContextExtractor(Supplier<TraceConfig> traceConfigSupplier, ContextInterpreter.Factory factory) {
        this.traceConfigSupplier = traceConfigSupplier;
        this.ctxInterpreter = ThreadLocal.withInitial(factory::create);
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        ContextInterpreter interpreter = this.ctxInterpreter.get().reset(this.traceConfigSupplier.get());
        getter.forEachKey(carrier, interpreter);
        return interpreter.build();
    }
}

