/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Config;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.util.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DynamicConfig {
    private State initialState;
    private volatile State currentState;

    private DynamicConfig() {
    }

    public static Builder create() {
        return new DynamicConfig().initial();
    }

    public TraceConfig captureTraceConfig() {
        return this.currentState;
    }

    public Builder initial() {
        return new Builder(this.initialState);
    }

    public Builder current() {
        return new Builder(this.currentState);
    }

    public void resetTraceConfig() {
        this.currentState = this.initialState;
    }

    static final class State
    implements TraceConfig {
        final Map<String, String> serviceMapping;
        final Map<String, String> headerTags;
        final Map<String, String> baggageMapping;
        private final boolean overrideResponseTags;

        State(Builder builder, State initialState) {
            this.serviceMapping = builder.serviceMapping;
            this.headerTags = builder.headerTags;
            this.baggageMapping = builder.baggageMapping;
            this.overrideResponseTags = null != initialState && this.headerTags != initialState.headerTags;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }

        @Override
        public Map<String, String> getHeaderTags() {
            return this.headerTags;
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return this.overrideResponseTags ? this.headerTags : Config.get().getResponseHeaderTags();
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return this.baggageMapping;
        }
    }

    public final class Builder {
        Map<String, String> serviceMapping;
        Map<String, String> headerTags;
        Map<String, String> baggageMapping;

        Builder(State state) {
            if (null == state) {
                this.serviceMapping = Collections.emptyMap();
                this.headerTags = Collections.emptyMap();
                this.baggageMapping = Collections.emptyMap();
            } else {
                this.serviceMapping = state.serviceMapping;
                this.headerTags = state.headerTags;
                this.baggageMapping = state.baggageMapping;
            }
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            return this.setServiceMapping(serviceMapping.entrySet());
        }

        public Builder setHeaderTags(Map<String, String> headerTags) {
            return this.setHeaderTags(headerTags.entrySet());
        }

        public Builder setBaggageMapping(Map<String, String> baggageMapping) {
            return this.setBaggageMapping(baggageMapping.entrySet());
        }

        public Builder setServiceMapping(Collection<? extends Map.Entry<String, String>> serviceMapping) {
            this.serviceMapping = this.cleanMapping(serviceMapping, false, false);
            return this;
        }

        public Builder setHeaderTags(Collection<? extends Map.Entry<String, String>> headerTags) {
            this.headerTags = this.cleanMapping(headerTags, true, true);
            return this;
        }

        public Builder setBaggageMapping(Collection<? extends Map.Entry<String, String>> baggageMapping) {
            this.baggageMapping = this.cleanMapping(baggageMapping, true, false);
            return this;
        }

        private Map<String, String> cleanMapping(Collection<? extends Map.Entry<String, String>> mapping, boolean lowerCaseKeys, boolean lowerCaseValues) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
            for (Map.Entry<String, String> entry : mapping) {
                String key = entry.getKey().trim();
                if (lowerCaseKeys) {
                    key = key.toLowerCase();
                }
                String value = entry.getValue().trim();
                if (lowerCaseValues) {
                    value = value.toLowerCase();
                }
                cleanedMapping.put(key, value);
            }
            return CollectionUtils.tryMakeImmutableMap(cleanedMapping);
        }

        public DynamicConfig apply() {
            State newState = new State(this, DynamicConfig.this.initialState);
            State oldState = DynamicConfig.this.currentState;
            if (null == oldState) {
                DynamicConfig.this.initialState = newState;
                DynamicConfig.this.currentState = newState;
            } else {
                DynamicConfig.this.currentState = newState;
                HashMap<String, Object> update = new HashMap<String, Object>();
                update.put("service.mapping", newState.serviceMapping);
                update.put("trace.header.tags", newState.headerTags);
                update.put("trace.header.baggage", newState.baggageMapping);
                ConfigCollector.get().putAll(update);
            }
            return DynamicConfig.this;
        }
    }
}

