/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

public enum ResolverCacheConfig {
    LARGE{

        @Override
        public int noMatchesSize() {
            return 65536;
        }

        @Override
        public int memoPoolSize() {
            return 4096;
        }

        @Override
        public int outlinePoolSize() {
            return 256;
        }

        @Override
        public int typePoolSize() {
            return 64;
        }
    }
    ,
    MEMOS{

        @Override
        public int noMatchesSize() {
            return 16384;
        }

        @Override
        public int memoPoolSize() {
            return 2048;
        }

        @Override
        public int outlinePoolSize() {
            return 128;
        }

        @Override
        public int typePoolSize() {
            return 32;
        }
    }
    ,
    NO_MEMOS{

        @Override
        public int noMatchesSize() {
            return 0;
        }

        @Override
        public int memoPoolSize() {
            return 0;
        }

        @Override
        public int outlinePoolSize() {
            return 256;
        }

        @Override
        public int typePoolSize() {
            return 32;
        }
    }
    ,
    SMALL{

        @Override
        public int noMatchesSize() {
            return 0;
        }

        @Override
        public int memoPoolSize() {
            return 0;
        }

        @Override
        public int outlinePoolSize() {
            return 32;
        }

        @Override
        public int typePoolSize() {
            return 16;
        }
    }
    ,
    LEGACY{

        @Override
        public int noMatchesSize() {
            return 0;
        }

        @Override
        public int memoPoolSize() {
            return 0;
        }

        @Override
        public int outlinePoolSize() {
            return 0;
        }

        @Override
        public int typePoolSize() {
            return 64;
        }
    };


    public abstract int noMatchesSize();

    public abstract int memoPoolSize();

    public abstract int outlinePoolSize();

    public abstract int typePoolSize();
}

