/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v1;

import ddtrot.dd.trace.api.naming.NamingSchema;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PeerServiceNamingV1
implements NamingSchema.ForPeerService {
    private static final Map<Object, String[]> SPECIFIC_PRECURSORS_BY_COMPONENT = PeerServiceNamingV1.initPrecursorsByComponent();
    private static final String[] DEFAULT_PRECURSORS = new String[]{"db.instance", "peer.hostname"};

    private static Map<Object, String[]> initPrecursorsByComponent() {
        HashMap<Object, String[]> ret = new HashMap<Object, String[]>(7);
        ret.put("java-kafka", new String[]{"messaging.kafka.bootstrap.servers"});
        ret.put("hazelcast-sdk", new String[]{"hazelcast.instance", "peer.hostname"});
        ret.put("couchbase-client", new String[]{"db.couchbase.seed.nodes", "net.peer.name", "peer.hostname"});
        ret.put("java-cassandra", new String[]{"peer.hostname"});
        String[] rpcPrecursors = new String[]{"rpc.service", "peer.hostname"};
        ret.put("grpc-client", rpcPrecursors);
        ret.put("rmi-client", rpcPrecursors);
        ret.put("java-aws-sdk", new String[0]);
        return ret;
    }

    @Override
    public boolean supports() {
        return true;
    }

    private void resolve(@Nonnull Map<String, Object> unsafeTags) {
        Object component = unsafeTags.get("component");
        if (this.resolveBy(unsafeTags, SPECIFIC_PRECURSORS_BY_COMPONENT.get(component == null ? null : component.toString()))) {
            return;
        }
        this.resolveBy(unsafeTags, DEFAULT_PRECURSORS);
    }

    private boolean resolveBy(@Nonnull Map<String, Object> unsafeTags, @Nullable String[] precursors) {
        if (precursors == null) {
            return false;
        }
        Object value = null;
        String source = null;
        for (String precursor : precursors) {
            value = unsafeTags.get(precursor);
            if (value == null) continue;
            source = precursor;
            break;
        }
        if (value != null) {
            unsafeTags.put("peer.service", value);
            unsafeTags.put("_dd.peer.service.source", source);
        }
        return true;
    }

    @Override
    @Nonnull
    public Map<String, Object> tags(@Nonnull Map<String, Object> unsafeTags) {
        Object kind = unsafeTags.get("span.kind");
        if ("client".equals(kind) || "producer".equals(kind)) {
            this.resolve(unsafeTags);
        }
        return unsafeTags;
    }
}

