/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDEvpProxyApi
extends RemoteApi {
    private static final Logger log = LoggerFactory.getLogger(DDEvpProxyApi.class);
    private static final String DD_EVP_SUBDOMAIN_HEADER = "X-Datadog-EVP-Subdomain";
    private final OkHttpClient httpClient;
    private final HttpUrl proxiedApiUrl;
    private final String subdomain;
    private final HttpRetryPolicy.Factory retryPolicyFactory;

    public static DDEvpProxyApiBuilder builder() {
        return new DDEvpProxyApiBuilder();
    }

    private DDEvpProxyApi(OkHttpClient httpClient, HttpUrl proxiedApiUrl, String subdomain, HttpRetryPolicy.Factory retryPolicyFactory) {
        this.httpClient = httpClient;
        this.proxiedApiUrl = proxiedApiUrl;
        this.subdomain = subdomain;
        this.retryPolicyFactory = retryPolicyFactory;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        sizeInBytes = payload.sizeInBytes();
        try {
            request = new Request.Builder().url(this.proxiedApiUrl).addHeader("X-Datadog-EVP-Subdomain", this.subdomain).post(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            retryPolicy = this.retryPolicyFactory.create();
            while (true) lbl-1000:
            // 2 sources

            {
                block26: {
                    try {
                        response = this.httpClient.newCall(request).execute();
                        var6_9 = null;
                        try {
                            if (response.isSuccessful()) {
                                this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                                var7_12 = RemoteApi.Response.success(response.code());
                                return var7_12;
                            }
                            if (!retryPolicy.shouldRetry(response)) {
                                this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response, null);
                                var7_13 = RemoteApi.Response.failed(response.code());
                                return var7_13;
                            }
                        }
                        catch (Throwable var7_14) {
                            var6_9 = var7_14;
                            throw var7_14;
                        }
                        finally {
                            if (response != null) {
                                if (var6_9 != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable var8_16) {
                                        var6_9.addSuppressed(var8_16);
                                    }
                                } else {
                                    response.close();
                                }
                            }
                        }
                    }
                    catch (ConnectException ex) {
                        shouldRetry = retryPolicy.shouldRetry(null);
                        if (shouldRetry) break block26;
                        this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
                        return RemoteApi.Response.failed(ex);
                    }
                }
                backoffMs = retryPolicy.backoff();
                try {
                    Thread.sleep(backoffMs);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                break;
            }
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
        {
            ** while (true)
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDEvpProxyApiBuilder {
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl agentUrl = null;
        OkHttpClient httpClient = null;
        String evpProxyEndpoint;

        public DDEvpProxyApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDEvpProxyApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDEvpProxyApiBuilder evpProxyEndpoint(String evpProxyEndpoint) {
            this.evpProxyEndpoint = evpProxyEndpoint;
            return this;
        }

        public DDEvpProxyApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDEvpProxyApiBuilder agentUrl(HttpUrl agentUrl) {
            this.agentUrl = agentUrl;
            return this;
        }

        DDEvpProxyApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDEvpProxyApi build() {
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase();
            String subdomain = String.format("%s-intake", trackName);
            HttpUrl evpProxyUrl = this.agentUrl.resolve(this.evpProxyEndpoint);
            HttpUrl proxiedApiUrl = evpProxyUrl.resolve(String.format("api/%s/%s", this.apiVersion, trackName));
            OkHttpClient client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(proxiedApiUrl, this.timeoutMillis);
            HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0);
            log.debug("proxiedApiUrl: " + proxiedApiUrl);
            return new DDEvpProxyApi(client, proxiedApiUrl, subdomain, retryPolicyFactory);
        }
    }
}

