/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.BufferPool;
import ddtrot.com.timgroup.statsd.InvalidMessageException;
import ddtrot.com.timgroup.statsd.Message;
import ddtrot.com.timgroup.statsd.StatsDAggregator;
import ddtrot.com.timgroup.statsd.StatsDClientErrorHandler;
import ddtrot.com.timgroup.statsd.Telemetry;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;

public abstract class StatsDProcessor {
    protected static final Charset MESSAGE_CHARSET = Charset.forName("UTF-8");
    protected static final String MESSAGE_TOO_LONG = "Message longer than size of sendBuffer";
    protected static final int WAIT_SLEEP_MS = 10;
    protected final StatsDClientErrorHandler handler;
    protected final BufferPool bufferPool;
    protected final Queue<Message> highPrioMessages;
    protected final BlockingQueue<ByteBuffer> outboundQueue;
    protected final CountDownLatch endSignal;
    final CountDownLatch closeSignal;
    protected final ThreadFactory threadFactory;
    protected final Thread[] workers;
    protected final int qcapacity;
    protected StatsDAggregator aggregator;
    protected volatile Telemetry telemetry;
    protected volatile boolean shutdown;
    volatile boolean shutdownAgg;
    String containerID;

    StatsDProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory, String containerID) throws Exception {
        this.handler = handler;
        this.threadFactory = threadFactory;
        this.workers = new Thread[workers];
        this.qcapacity = queueSize;
        this.bufferPool = new BufferPool(poolSize, maxPacketSizeBytes, true);
        this.highPrioMessages = new ConcurrentLinkedQueue<Message>();
        this.outboundQueue = new ArrayBlockingQueue<ByteBuffer>(poolSize);
        this.endSignal = new CountDownLatch(workers);
        this.closeSignal = new CountDownLatch(workers);
        this.aggregator = new StatsDAggregator(this, aggregatorShards, aggregatorFlushInterval);
        this.containerID = containerID;
    }

    protected abstract ProcessingTask createProcessingTask();

    protected abstract boolean send(Message var1);

    protected boolean sendHighPrio(Message message) {
        this.highPrioMessages.offer(message);
        return true;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public BlockingQueue<ByteBuffer> getOutboundQueue() {
        return this.outboundQueue;
    }

    public int getQcapacity() {
        return this.qcapacity;
    }

    void startWorkers(String namePrefix) {
        this.aggregator.start();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.threadFactory.newThread(this.createProcessingTask());
            this.workers[i].setName(namePrefix + (i + 1));
            this.workers[i].start();
        }
    }

    public StatsDAggregator getAggregator() {
        return this.aggregator;
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    void shutdown(boolean blocking) throws InterruptedException {
        this.shutdown = true;
        this.aggregator.stop();
        if (blocking) {
            this.closeSignal.await();
            this.aggregator.flush();
            this.shutdownAgg = true;
            this.endSignal.await();
        } else {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].interrupt();
            }
        }
    }

    protected abstract class ProcessingTask
    implements Runnable {
        protected StringBuilder builder = new StringBuilder();
        protected CharBuffer buffer = CharBuffer.wrap(this.builder);
        protected final CharsetEncoder utf8Encoder = MESSAGE_CHARSET.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

        protected ProcessingTask() {
        }

        @Override
        public final void run() {
            try {
                this.processLoop();
            }
            finally {
                StatsDProcessor.this.endSignal.countDown();
            }
        }

        protected void processLoop() {
            ByteBuffer sendBuffer;
            try {
                sendBuffer = StatsDProcessor.this.bufferPool.borrow();
            }
            catch (InterruptedException e) {
                return;
            }
            boolean clientClosed = false;
            while (!Thread.interrupted()) {
                try {
                    boolean shutdown = StatsDProcessor.this.shutdown;
                    boolean shutdownAgg = StatsDProcessor.this.shutdownAgg;
                    Message message = StatsDProcessor.this.highPrioMessages.poll();
                    if (message == null && shutdownAgg) break;
                    if (message == null && !clientClosed) {
                        message = this.getMessage();
                    }
                    if (message == null) {
                        if (shutdown && !clientClosed) {
                            StatsDProcessor.this.closeSignal.countDown();
                            clientClosed = true;
                        }
                        if (!clientClosed) continue;
                        Thread.sleep(10L);
                        continue;
                    }
                    if (StatsDProcessor.this.aggregator.aggregateMessage(message)) continue;
                    this.builder.setLength(0);
                    message.writeTo(this.builder, StatsDProcessor.this.containerID);
                    int lowerBoundSize = this.builder.length();
                    if (sendBuffer.capacity() < lowerBoundSize) {
                        throw new InvalidMessageException(StatsDProcessor.MESSAGE_TOO_LONG, this.builder.toString());
                    }
                    if (sendBuffer.remaining() < lowerBoundSize + 1) {
                        StatsDProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                    }
                    sendBuffer.mark();
                    try {
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    catch (BufferOverflowException boe) {
                        StatsDProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    if (this.haveMessages()) continue;
                    StatsDProcessor.this.outboundQueue.put(sendBuffer);
                    sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    StatsDProcessor.this.handler.handle(e);
                }
            }
            this.builder.setLength(0);
            this.builder.trimToSize();
        }

        abstract boolean haveMessages();

        abstract Message getMessage() throws InterruptedException;

        protected void writeBuilderToSendBuffer(ByteBuffer sendBuffer) {
            int length = this.builder.length();
            if (length <= this.buffer.capacity()) {
                this.buffer.limit(length).position(0);
            } else {
                this.buffer = CharBuffer.wrap(this.builder);
            }
            if (this.utf8Encoder.encode(this.buffer, sendBuffer, true) == CoderResult.OVERFLOW) {
                throw new BufferOverflowException();
            }
        }
    }
}

