/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.sink;

import ddtrot.dd.trace.api.iast.IastModule;
import java.net.HttpCookie;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public interface HttpResponseHeaderModule
extends IastModule {

    public static class Delegated
    implements ForHeader,
    ForCookie {
        private static final String SET_COOKIE_HEADER = "Set-Cookie";
        private final List<ForHeader> forHeaders = new LinkedList<ForHeader>();
        private final List<ForCookie> forCookies = new LinkedList<ForCookie>();

        public void clear() {
            this.forHeaders.clear();
            this.forCookies.clear();
        }

        public void addDelegate(@Nonnull HttpResponseHeaderModule delegate) {
            if (delegate instanceof ForHeader) {
                this.forHeaders.add((ForHeader)delegate);
            }
            if (delegate instanceof ForCookie) {
                this.forCookies.add((ForCookie)delegate);
            }
        }

        @Override
        public void onHeader(@Nonnull String name, String value) {
            List<HttpCookie> cookies;
            if (!this.forCookies.isEmpty() && SET_COOKIE_HEADER.equalsIgnoreCase(name) && !(cookies = HttpCookie.parse(value)).isEmpty()) {
                HttpCookie first = cookies.get(0);
                this.onCookie(first.getName(), first.getValue(), first.getSecure(), first.isHttpOnly(), null);
            }
            for (ForHeader handler : this.forHeaders) {
                handler.onHeader(name, value);
            }
        }

        @Override
        public void onCookie(@Nonnull String name, String value, boolean isSecure, boolean isHttpOnly, String sameSite) {
            for (ForCookie handler : this.forCookies) {
                handler.onCookie(name, value, isSecure, isHttpOnly, sameSite);
            }
        }
    }

    public static interface ForCookie
    extends HttpResponseHeaderModule {
        public void onCookie(@Nonnull String var1, String var2, boolean var3, boolean var4, String var5);
    }

    public static interface ForHeader
    extends HttpResponseHeaderModule {
        public void onHeader(@Nonnull String var1, String var2);
    }
}

