/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface MetricCollector<M extends Metric> {
    public static final int RAW_QUEUE_SIZE = 1024;

    public void prepareMetrics();

    public Collection<M> drain();

    public static class Metric {
        public final String metricName;
        public final boolean common;
        public final long timestamp;
        public final long counter;
        public final String namespace;
        public final List<String> tags;

        public Metric(String namespace, boolean common, String metricName, long counter, String tag) {
            this(namespace, common, metricName, counter, tag == null ? Collections.emptyList() : Collections.singletonList(tag));
        }

        public Metric(String namespace, boolean common, String metricName, long counter, String ... tags) {
            this(namespace, common, metricName, counter, Arrays.asList(tags));
        }

        public Metric(String namespace, boolean common, String metricName, long counter, List<String> tags) {
            this.common = common;
            this.metricName = metricName;
            this.timestamp = System.currentTimeMillis() / 1000L;
            this.counter = counter;
            this.namespace = namespace;
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric metric = (Metric)o;
            return this.common == metric.common && Objects.equals(this.metricName, metric.metricName) && Objects.equals(this.namespace, metric.namespace) && Objects.equals(this.tags, metric.tags);
        }

        public int hashCode() {
            return Objects.hash(this.metricName, this.common, this.namespace, this.tags);
        }
    }
}

