/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.dd.trace.core.PendingTraceBuffer;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LongRunningTracesTracker {
    private final DDAgentFeaturesDiscovery features;
    private final HealthMetrics healthMetrics;
    private long lastFlushMilli = 0L;
    private final int maxTrackedTraces;
    private final int flushPeriodMilli;
    private final long maxTrackedDurationMilli = TimeUnit.HOURS.toMillis(12L);
    private final List<PendingTrace> traceArray = new ArrayList<PendingTrace>(16);
    private int dropped = 0;
    private int write = 0;
    private int expired = 0;
    public static final int NOT_TRACKED = -1;
    public static final int UNDEFINED = 0;
    public static final int TO_TRACK = 1;
    public static final int TRACKED = 2;
    public static final int WRITE_RUNNING_SPANS = 3;
    public static final int EXPIRED = 4;

    public LongRunningTracesTracker(Config config, int maxTrackedTraces, SharedCommunicationObjects sharedCommunicationObjects, HealthMetrics healthMetrics) {
        this.maxTrackedTraces = maxTrackedTraces;
        this.flushPeriodMilli = (int)TimeUnit.SECONDS.toMillis(config.getLongRunningTraceFlushInterval());
        this.features = sharedCommunicationObjects.featuresDiscovery(config);
        this.healthMetrics = healthMetrics;
    }

    public boolean add(PendingTraceBuffer.Element element) {
        if (!(element instanceof PendingTrace)) {
            return false;
        }
        PendingTrace trace = (PendingTrace)element;
        if (!trace.compareAndSetLongRunningState(1, 2)) {
            return false;
        }
        this.addTrace(trace);
        return true;
    }

    private void addTrace(PendingTrace trace) {
        if (trace.empty()) {
            return;
        }
        if (this.traceArray.size() == this.maxTrackedTraces) {
            ++this.dropped;
            return;
        }
        this.traceArray.add(trace);
    }

    public void flushAndCompact(long nowMilli) {
        if (nowMilli < this.lastFlushMilli + TimeUnit.SECONDS.toMillis(1L)) {
            return;
        }
        int i = 0;
        while (i < this.traceArray.size()) {
            PendingTrace trace = this.traceArray.get(i);
            if (trace == null) {
                this.cleanSlot(i);
                continue;
            }
            if (trace.empty() || !this.features.supportsLongRunning()) {
                trace.compareAndSetLongRunningState(3, -1);
                this.cleanSlot(i);
                continue;
            }
            if (this.hasExpired(nowMilli, trace)) {
                trace.compareAndSetLongRunningState(3, 4);
                ++this.expired;
                this.cleanSlot(i);
                continue;
            }
            if (this.shouldFlush(nowMilli, trace)) {
                if (this.negativeOrNullPriority(trace)) {
                    trace.compareAndSetLongRunningState(2, -1);
                    this.cleanSlot(i);
                    continue;
                }
                trace.compareAndSetLongRunningState(2, 3);
                ++this.write;
                trace.write();
            }
            ++i;
        }
        this.lastFlushMilli = nowMilli;
        this.flushStats();
    }

    private boolean hasExpired(long nowMilli, PendingTrace trace) {
        return nowMilli - TimeUnit.NANOSECONDS.toMillis(trace.getRunningTraceStartTime()) > this.maxTrackedDurationMilli;
    }

    private boolean shouldFlush(long nowMilli, PendingTrace trace) {
        return nowMilli - TimeUnit.NANOSECONDS.toMillis(Math.max(trace.getRunningTraceStartTime(), trace.getLastWriteTime())) > (long)this.flushPeriodMilli;
    }

    private void cleanSlot(int index) {
        int lastElementIndex = this.traceArray.size() - 1;
        this.traceArray.set(index, this.traceArray.get(lastElementIndex));
        this.traceArray.remove(lastElementIndex);
    }

    private boolean negativeOrNullPriority(PendingTrace trace) {
        Integer prio = trace.evaluateSamplingPriority();
        return prio == null || prio <= 0;
    }

    private void flushStats() {
        this.healthMetrics.onLongRunningUpdate(this.dropped, this.write, this.expired);
        this.dropped = 0;
        this.write = 0;
        this.expired = 0;
    }
}

