/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Config;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.util.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;

public final class DynamicConfig<S extends Snapshot> {
    BiFunction<Builder, S, S> snapshotFactory;
    S initialSnapshot;
    volatile S currentSnapshot;

    private DynamicConfig(BiFunction<Builder, S, S> snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
    }

    public static Builder create() {
        return new DynamicConfig<Snapshot>(Snapshot::new).initial();
    }

    public static <S extends Snapshot> Builder create(BiFunction<Builder, S, S> snapshotFactory) {
        return new DynamicConfig<S>(snapshotFactory).initial();
    }

    public S captureTraceConfig() {
        return this.currentSnapshot;
    }

    public Builder initial() {
        return new Builder((Snapshot)this.initialSnapshot);
    }

    public Builder current() {
        return new Builder((Snapshot)this.currentSnapshot);
    }

    public void resetTraceConfig() {
        this.currentSnapshot = this.initialSnapshot;
        DynamicConfig.reportConfigChange(this.initialSnapshot);
    }

    static void reportConfigChange(Snapshot newSnapshot) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("trace.debug", newSnapshot.debugEnabled);
        update.put("runtime.metrics.enabled", newSnapshot.runtimeMetricsEnabled);
        update.put("logs.injection", newSnapshot.logsInjectionEnabled);
        update.put("data.streams.enabled", newSnapshot.dataStreamsEnabled);
        update.put("service.mapping", newSnapshot.serviceMapping);
        update.put("trace.header.tags", newSnapshot.headerTags);
        update.put("trace.header.baggage", newSnapshot.baggageMapping);
        DynamicConfig.maybePut(update, "trace.sample.rate", newSnapshot.traceSampleRate);
        ConfigCollector.get().putAll(update);
    }

    private static void maybePut(Map<String, Object> update, String key, Object value) {
        if (null != value) {
            update.put(key, value);
        }
    }

    public static class Snapshot
    implements TraceConfig {
        final boolean debugEnabled;
        final boolean runtimeMetricsEnabled;
        final boolean logsInjectionEnabled;
        final boolean dataStreamsEnabled;
        final Map<String, String> serviceMapping;
        final Map<String, String> headerTags;
        final Map<String, String> baggageMapping;
        final boolean overrideResponseTags;
        final Double traceSampleRate;

        protected Snapshot(Builder builder, Snapshot oldSnapshot) {
            this.debugEnabled = builder.debugEnabled;
            this.runtimeMetricsEnabled = builder.runtimeMetricsEnabled;
            this.logsInjectionEnabled = builder.logsInjectionEnabled;
            this.dataStreamsEnabled = builder.dataStreamsEnabled;
            this.serviceMapping = builder.serviceMapping;
            this.headerTags = builder.headerTags;
            this.baggageMapping = builder.baggageMapping;
            this.overrideResponseTags = builder.overrideResponseTags;
            this.traceSampleRate = builder.traceSampleRate;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return this.runtimeMetricsEnabled;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return this.logsInjectionEnabled;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return this.dataStreamsEnabled;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }

        @Override
        public Map<String, String> getHeaderTags() {
            return this.headerTags;
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return this.overrideResponseTags ? this.headerTags : Config.get().getResponseHeaderTags();
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return this.baggageMapping;
        }

        @Override
        public Double getTraceSampleRate() {
            return this.traceSampleRate;
        }
    }

    public final class Builder {
        boolean debugEnabled;
        boolean runtimeMetricsEnabled;
        boolean logsInjectionEnabled;
        boolean dataStreamsEnabled;
        Map<String, String> serviceMapping;
        Map<String, String> headerTags;
        Map<String, String> baggageMapping;
        boolean overrideResponseTags;
        Double traceSampleRate;

        Builder(Snapshot snapshot) {
            if (null == snapshot) {
                this.serviceMapping = Collections.emptyMap();
                this.headerTags = Collections.emptyMap();
                this.baggageMapping = Collections.emptyMap();
                this.logsInjectionEnabled = true;
            } else {
                this.debugEnabled = snapshot.debugEnabled;
                this.runtimeMetricsEnabled = snapshot.runtimeMetricsEnabled;
                this.logsInjectionEnabled = snapshot.logsInjectionEnabled;
                this.dataStreamsEnabled = snapshot.dataStreamsEnabled;
                this.serviceMapping = snapshot.serviceMapping;
                this.headerTags = snapshot.headerTags;
                this.baggageMapping = snapshot.baggageMapping;
                this.overrideResponseTags = snapshot.overrideResponseTags;
                this.traceSampleRate = snapshot.traceSampleRate;
            }
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setRuntimeMetricsEnabled(boolean runtimeMetricsEnabled) {
            this.runtimeMetricsEnabled = runtimeMetricsEnabled;
            return this;
        }

        public Builder setLogsInjectionEnabled(boolean logsInjectionEnabled) {
            this.logsInjectionEnabled = logsInjectionEnabled;
            return this;
        }

        public Builder setDataStreamsEnabled(boolean dataStreamsEnabled) {
            this.dataStreamsEnabled = dataStreamsEnabled;
            return this;
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            return this.setServiceMapping(serviceMapping.entrySet());
        }

        public Builder setHeaderTags(Map<String, String> headerTags) {
            if (Config.get().getRequestHeaderTags().equals(headerTags) && !Config.get().getResponseHeaderTags().equals(headerTags)) {
                this.headerTags = this.cleanMapping(headerTags.entrySet(), true, true);
                this.overrideResponseTags = false;
                return this;
            }
            return this.setHeaderTags(headerTags.entrySet());
        }

        public Builder setBaggageMapping(Map<String, String> baggageMapping) {
            return this.setBaggageMapping(baggageMapping.entrySet());
        }

        public Builder setServiceMapping(Collection<? extends Map.Entry<String, String>> serviceMapping) {
            this.serviceMapping = this.cleanMapping(serviceMapping, false, false);
            return this;
        }

        public Builder setHeaderTags(Collection<? extends Map.Entry<String, String>> headerTags) {
            this.headerTags = this.cleanMapping(headerTags, true, true);
            this.overrideResponseTags = true;
            return this;
        }

        public Builder setBaggageMapping(Collection<? extends Map.Entry<String, String>> baggageMapping) {
            this.baggageMapping = this.cleanMapping(baggageMapping, true, false);
            return this;
        }

        public Builder setTraceSampleRate(Double traceSampleRate) {
            this.traceSampleRate = traceSampleRate;
            return this;
        }

        private Map<String, String> cleanMapping(Collection<? extends Map.Entry<String, String>> mapping, boolean lowerCaseKeys, boolean lowerCaseValues) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
            for (Map.Entry<String, String> entry : mapping) {
                String key = entry.getKey().trim();
                if (lowerCaseKeys) {
                    key = key.toLowerCase(Locale.ROOT);
                }
                String value = entry.getValue().trim();
                if (lowerCaseValues) {
                    value = value.toLowerCase(Locale.ROOT);
                }
                cleanedMapping.put(key, value);
            }
            return CollectionUtils.tryMakeImmutableMap(cleanedMapping);
        }

        public DynamicConfig<S> apply() {
            Object oldSnapshot = DynamicConfig.this.currentSnapshot;
            Snapshot newSnapshot = (Snapshot)DynamicConfig.this.snapshotFactory.apply(this, oldSnapshot);
            if (null == oldSnapshot) {
                DynamicConfig.this.initialSnapshot = newSnapshot;
                DynamicConfig.this.currentSnapshot = newSnapshot;
            } else {
                DynamicConfig.this.currentSnapshot = newSnapshot;
                DynamicConfig.reportConfigChange(newSnapshot);
            }
            return DynamicConfig.this;
        }
    }
}

