/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.ProductActivation;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.JsonWriter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.logging.LoggingSettingsDescription;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusLogger
extends JsonAdapter<Config>
implements AgentTaskScheduler.Task<Config>,
JsonAdapter.Factory {
    public static void logStatus(Config config) {
        AgentTaskScheduler.INSTANCE.schedule(new StatusLogger(), config, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run(Config config) {
        Logger log = LoggerFactory.getLogger(StatusLogger.class);
        if (log.isInfoEnabled()) {
            log.info("DATADOG TRACER CONFIGURATION {}", (Object)new Moshi.Builder().add(this).build().adapter(Config.class).toJson(config));
        }
        if (log.isDebugEnabled()) {
            log.debug("class path: {}", (Object)System.getProperty("java.class.path"));
        }
    }

    @Override
    public Config fromJson(JsonReader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toJson(JsonWriter writer, Config config) throws IOException {
        if (null == config) {
            return;
        }
        writer.beginObject();
        writer.name("version");
        writer.value(DDTraceCoreInfo.VERSION);
        writer.name("os_name");
        writer.value(System.getProperty("os.name"));
        writer.name("os_version");
        writer.value(System.getProperty("os.version"));
        writer.name("architecture");
        writer.value(System.getProperty("os.arch"));
        writer.name("lang");
        writer.value("jvm");
        writer.name("lang_version");
        writer.value(System.getProperty("java.version"));
        writer.name("jvm_vendor");
        writer.value(System.getProperty("java.vendor"));
        writer.name("jvm_version");
        writer.value(System.getProperty("java.vm.version"));
        writer.name("java_class_version");
        writer.value(System.getProperty("java.class.version"));
        writer.name("http_nonProxyHosts");
        writer.value(String.valueOf(System.getProperty("http.nonProxyHosts")));
        writer.name("http_proxyHost");
        writer.value(String.valueOf(System.getProperty("http.proxyHost")));
        writer.name("enabled");
        writer.value(config.isTraceEnabled());
        writer.name("service");
        writer.value(config.getServiceName());
        writer.name("agent_url");
        writer.value(config.getAgentUrl());
        writer.name("agent_unix_domain_socket");
        writer.value(config.getAgentUnixDomainSocket());
        writer.name("agent_named_pipe");
        writer.value(config.getAgentNamedPipe());
        writer.name("agent_error");
        writer.value(!StatusLogger.agentServiceCheck(config));
        writer.name("debug");
        writer.value(config.isDebugEnabled());
        writer.name("trace_propagation_style_extract");
        writer.beginArray();
        StatusLogger.writeSet(writer, config.getTracePropagationStylesToExtract());
        writer.endArray();
        writer.name("trace_propagation_style_inject");
        writer.beginArray();
        StatusLogger.writeSet(writer, config.getTracePropagationStylesToInject());
        writer.endArray();
        writer.name("analytics_enabled");
        writer.value(config.isTraceAnalyticsEnabled());
        writer.name("sample_rate");
        writer.value(config.getTraceSampleRate());
        writer.name("sampling_rules");
        writer.beginArray();
        StatusLogger.writeMap(writer, config.getTraceSamplingServiceRules());
        StatusLogger.writeMap(writer, config.getTraceSamplingOperationRules());
        writer.endArray();
        writer.name("priority_sampling_enabled");
        writer.value(config.isPrioritySamplingEnabled());
        writer.name("logs_correlation_enabled");
        writer.value(config.isLogsInjectionEnabled());
        writer.name("profiling_enabled");
        writer.value(config.isProfilingEnabled());
        writer.name("remote_config_enabled");
        writer.value(config.isRemoteConfigEnabled());
        writer.name("debugger_enabled");
        writer.value(config.isDebuggerEnabled());
        writer.name("appsec_enabled");
        writer.value(config.getAppSecActivation().toString());
        writer.name("appsec_rules_file_path");
        writer.value(config.getAppSecRulesFile());
        writer.name("telemetry_enabled");
        writer.value(config.isTelemetryEnabled());
        writer.name("dd_version");
        writer.value(config.getVersion());
        writer.name("health_checks_enabled");
        writer.value(config.isHealthMetricsEnabled());
        writer.name("configuration_file");
        writer.value(config.getConfigFileStatus());
        writer.name("runtime_id");
        writer.value(config.getRuntimeId());
        writer.name("logging_settings");
        StatusLogger.writeObjectMap(writer, LoggingSettingsDescription.getDescription());
        writer.name("cws_enabled");
        writer.value(config.isCwsEnabled());
        writer.name("cws_tls_refresh");
        writer.value(config.getCwsTlsRefresh());
        writer.name("datadog_profiler_enabled");
        writer.value(config.isDatadogProfilerEnabled());
        writer.name("datadog_profiler_safe");
        writer.value(Config.isDatadogProfilerSafeInCurrentEnvironment());
        writer.name("datadog_profiler_enabled_overridden");
        writer.value(Config.isDatadogProfilerEnablementOverridden());
        if (config.getIastActivation() != ProductActivation.FULLY_DISABLED) {
            writer.name("iast_enabled");
            writer.value(config.getIastActivation().toString());
        }
        writer.endObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean agentServiceCheck(Config config) {
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(config.getAgentHost(), config.getAgentPort()), 500);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void writeMap(JsonWriter writer, Map<String, String> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            writer.name(entry.getKey());
            writer.value(entry.getValue());
        }
        writer.endObject();
    }

    private static void writeObjectMap(JsonWriter writer, Map<String, Object> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.name(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Number) {
                writer.value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.value((Boolean)value);
                continue;
            }
            writer.value(String.valueOf(value));
        }
        writer.endObject();
    }

    private static void writeSet(JsonWriter writer, Set<?> set) throws IOException {
        for (Object o : set) {
            writer.value(o.toString());
        }
    }

    @Override
    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        return this;
    }
}

