/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.WellKnownTags;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.WritableFormatter;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.common.metrics.Sink;
import ddtrot.dd.trace.core.datastreams.DatastreamsPayloadWriter;
import ddtrot.dd.trace.core.datastreams.StatsBucket;
import ddtrot.dd.trace.core.datastreams.StatsGroup;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MsgPackDatastreamsPayloadWriter
implements DatastreamsPayloadWriter {
    private static final byte[] ENV = "Env".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] PRIMARY_TAG = "PrimaryTag".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] LANG = "Lang".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRACER_VERSION = "TracerVersion".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] STATS = "Stats".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] START = "Start".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] DURATION = "Duration".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] PATHWAY_LATENCY = "PathwayLatency".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EDGE_LATENCY = "EdgeLatency".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SERVICE = "Service".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EDGE_TAGS = "EdgeTags".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] BACKLOGS = "Backlogs".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HASH = "Hash".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] PARENT_HASH = "ParentHash".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] BACKLOG_VALUE = "Value".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] BACKLOG_TAGS = "Tags".getBytes(StandardCharsets.ISO_8859_1);
    private static final int INITIAL_CAPACITY = 524288;
    private final WritableFormatter writer;
    private final Sink sink;
    private final GrowableBuffer buffer = new GrowableBuffer(524288);
    private final WellKnownTags wellKnownTags;
    private final byte[] tracerVersionValue;
    private final byte[] primaryTagValue;

    public MsgPackDatastreamsPayloadWriter(Sink sink, WellKnownTags wellKnownTags, String tracerVersion, String primaryTag) {
        this.writer = new MsgPackWriter(this.buffer);
        this.sink = sink;
        this.wellKnownTags = wellKnownTags;
        this.tracerVersionValue = tracerVersion.getBytes(StandardCharsets.ISO_8859_1);
        this.primaryTagValue = primaryTag == null ? new byte[]{} : primaryTag.getBytes(StandardCharsets.ISO_8859_1);
    }

    public void reset() {
        this.buffer.reset();
    }

    @Override
    public void writePayload(Collection<StatsBucket> data) {
        this.writer.startMap(6);
        this.writer.writeUTF8(ENV);
        this.writer.writeUTF8(this.wellKnownTags.getEnv());
        this.writer.writeUTF8(SERVICE);
        this.writer.writeUTF8(this.wellKnownTags.getService());
        this.writer.writeUTF8(LANG);
        this.writer.writeUTF8(this.wellKnownTags.getLanguage());
        this.writer.writeUTF8(PRIMARY_TAG);
        this.writer.writeUTF8(this.primaryTagValue);
        this.writer.writeUTF8(TRACER_VERSION);
        this.writer.writeUTF8(this.tracerVersionValue);
        this.writer.writeUTF8(STATS);
        this.writer.startArray(data.size());
        for (StatsBucket bucket : data) {
            boolean hasBacklogs = !bucket.getBacklogs().isEmpty();
            this.writer.startMap(3 + (hasBacklogs ? 1 : 0));
            this.writer.writeUTF8(START);
            this.writer.writeLong(bucket.getStartTimeNanos());
            this.writer.writeUTF8(DURATION);
            this.writer.writeLong(bucket.getBucketDurationNanos());
            this.writer.writeUTF8(STATS);
            this.writeBucket(bucket, this.writer);
            if (!hasBacklogs) continue;
            this.writeBacklogs(bucket.getBacklogs(), this.writer);
        }
        this.buffer.mark();
        this.sink.accept(this.buffer.messageCount(), this.buffer.slice());
        this.buffer.reset();
    }

    private void writeBucket(StatsBucket bucket, Writable packer) {
        Collection<StatsGroup> groups = bucket.getGroups();
        packer.startArray(groups.size());
        for (StatsGroup group : groups) {
            boolean firstNode = group.getEdgeTags().isEmpty();
            packer.startMap(firstNode ? 4 : 5);
            packer.writeUTF8(PATHWAY_LATENCY);
            packer.writeBinary(group.getPathwayLatency().serialize());
            packer.writeUTF8(EDGE_LATENCY);
            packer.writeBinary(group.getEdgeLatency().serialize());
            packer.writeUTF8(HASH);
            packer.writeUnsignedLong(group.getHash());
            packer.writeUTF8(PARENT_HASH);
            packer.writeUnsignedLong(group.getParentHash());
            if (firstNode) continue;
            packer.writeUTF8(EDGE_TAGS);
            packer.startArray(group.getEdgeTags().size());
            for (String tag : group.getEdgeTags()) {
                packer.writeString(tag, null);
            }
        }
    }

    private void writeBacklogs(Collection<Map.Entry<List<String>, Long>> backlogs, Writable packer) {
        packer.writeUTF8(BACKLOGS);
        packer.startArray(backlogs.size());
        for (Map.Entry<List<String>, Long> entry : backlogs) {
            packer.startMap(2);
            packer.writeUTF8(BACKLOG_TAGS);
            packer.startArray(entry.getKey().size());
            for (String tag : entry.getKey()) {
                packer.writeString(tag, null);
            }
            packer.writeUTF8(BACKLOG_VALUE);
            packer.writeLong(entry.getValue());
        }
    }
}

