/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import ddtrot.dd.trace.util.AgentThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSupervisor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProcessSupervisor.class);
    private static final long MIN_RESTART_INTERVAL_MS = 10000L;
    private final String name;
    private final ProcessBuilder processBuilder;
    private final Thread supervisorThread;
    private long nextRestartTime = 0L;
    private volatile Process currentProcess;
    private volatile boolean stopped = false;

    public ProcessSupervisor(String name, ProcessBuilder processBuilder) {
        this.name = name;
        this.processBuilder = processBuilder;
        this.supervisorThread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.PROCESS_SUPERVISOR, new SupervisorLoop());
        this.supervisorThread.start();
    }

    @Override
    public void close() {
        this.stopped = true;
        this.supervisorThread.interrupt();
    }

    Process getCurrentProcess() {
        return this.currentProcess;
    }

    private class SupervisorLoop
    implements Runnable {
        private SupervisorLoop() {
        }

        @Override
        public void run() {
            try {
                while (!ProcessSupervisor.this.stopped) {
                    try {
                        if (ProcessSupervisor.this.currentProcess == null) {
                            long restartDelay = ProcessSupervisor.this.nextRestartTime - System.currentTimeMillis();
                            if (restartDelay > 0L) {
                                Thread.sleep(restartDelay);
                                continue;
                            }
                            log.debug("Starting process: [{}]", (Object)ProcessSupervisor.this.name);
                            ProcessSupervisor.this.nextRestartTime = System.currentTimeMillis() + 10000L;
                            ProcessSupervisor.this.currentProcess = ProcessSupervisor.this.processBuilder.start();
                        }
                        int code = ProcessSupervisor.this.currentProcess.waitFor();
                        log.debug("Process [{}] has exited with code {}", (Object)ProcessSupervisor.this.name, (Object)code);
                        ProcessSupervisor.this.currentProcess = null;
                    }
                    catch (InterruptedException code) {
                    }
                    catch (IOException e) {
                        log.error("Exception starting process: [{}]", (Object)ProcessSupervisor.this.name, (Object)e);
                    }
                }
            }
            finally {
                if (ProcessSupervisor.this.currentProcess != null) {
                    log.debug("Stopping process [{}]", (Object)ProcessSupervisor.this.name);
                    ProcessSupervisor.this.currentProcess.destroy();
                }
            }
        }
    }
}

