/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public final class Strings {
    public static String escapeToJson(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int sz = string.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = string.charAt(i);
            if (ch > '\u0fff') {
                sb.append("\\u").append(Strings.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                sb.append("\\u0").append(Strings.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                sb.append("\\u00").append(Strings.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        sb.append('\\').append('b');
                        break;
                    }
                    case '\t': {
                        sb.append('\\').append('t');
                        break;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            sb.append("\\u00").append(Strings.hex(ch));
                            break;
                        }
                        sb.append("\\u000").append(Strings.hex(ch));
                        break;
                    }
                    case '\f': {
                        sb.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block13;
                }
                case '\'': {
                    sb.append('\\').append('\'');
                    continue block13;
                }
                case '/': {
                    sb.append('\\').append('/');
                    continue block13;
                }
                case '\\': {
                    sb.append('\\').append('\\');
                    continue block13;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String toEnvVar(String string) {
        return string.replace('.', '_').replace('-', '_').toUpperCase();
    }

    public static String getResourceName(String className) {
        if (!className.endsWith(".class")) {
            return className.replace('.', '/') + ".class";
        }
        return className;
    }

    public static String getClassName(String resourceName) {
        if (resourceName.endsWith(".class")) {
            return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        }
        return resourceName.replace('/', '.');
    }

    public static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String getPackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        return lastDot < 0 ? "" : className.substring(0, lastDot);
    }

    public static String join(CharSequence joiner, Iterable<? extends CharSequence> strings) {
        if (strings == null) {
            return "";
        }
        Iterator<? extends CharSequence> it = strings.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CharSequence first = it.next();
        if (!it.hasNext()) {
            return first.toString();
        }
        StringBuilder sb = new StringBuilder(first);
        while (it.hasNext()) {
            sb.append(joiner).append(it.next());
        }
        return sb.toString();
    }

    public static String join(CharSequence joiner, CharSequence ... strings) {
        int len = strings.length;
        if (len > 0) {
            if (len == 1) {
                return strings[0].toString();
            }
            StringBuilder sb = new StringBuilder(strings[0]);
            for (int i = 1; i < len; ++i) {
                sb.append(joiner).append(strings[i]);
            }
            return sb.toString();
        }
        return "";
    }

    public static String replace(String str, String delimiter, String replacement) {
        int matchIndex;
        StringBuilder sb = new StringBuilder(str);
        int curIndex = 0;
        while ((matchIndex = sb.indexOf(delimiter, curIndex)) != -1) {
            sb.replace(matchIndex, matchIndex + delimiter.length(), replacement);
            curIndex = matchIndex + replacement.length();
        }
        return sb.toString();
    }

    public static String replaceFirst(String str, String delimiter, String replacement) {
        StringBuilder sb = new StringBuilder(str);
        int i = sb.indexOf(delimiter);
        if (i != -1) {
            sb.replace(i, i + delimiter.length(), replacement);
        }
        return sb.toString();
    }

    @Nonnull
    public static String propertyNameToEnvironmentVariableName(String setting) {
        return "DD_" + Strings.toEnvVar(setting);
    }

    @Nonnull
    public static String systemPropertyNameToEnvironmentVariableName(String setting) {
        return setting.replace('.', '_').replace('-', '_').toUpperCase();
    }

    @Nonnull
    public static String propertyNameToSystemPropertyName(String setting) {
        return "dd." + setting;
    }

    @Nonnull
    public static String trim(String string) {
        return null == string ? "" : string.trim();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static String sha256(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String truncate(String input, int limit) {
        return (String)Strings.truncate((CharSequence)input, limit);
    }

    public static CharSequence truncate(CharSequence input, int limit) {
        if (input == null || input.length() <= limit) {
            return input;
        }
        return input.subSequence(0, limit);
    }

    public static String toJson(Map<String, String> map) {
        return Strings.toJson(map, false);
    }

    public static String toJson(Map<String, String> map, boolean valuesAreJson) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<String, String>> entriesIter = map.entrySet().iterator();
        while (entriesIter.hasNext()) {
            Map.Entry<String, String> entry = entriesIter.next();
            sb.append("\"").append(Strings.escapeToJson(entry.getKey())).append("\":");
            if (valuesAreJson) {
                sb.append(entry.getValue());
            } else {
                sb.append("\"").append(Strings.escapeToJson(entry.getValue())).append("\"");
            }
            if (!entriesIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toJson(Iterable<String> items) {
        if (items == null) {
            return "[]";
        }
        StringBuilder json = new StringBuilder("[");
        Iterator<String> it = items.iterator();
        while (it.hasNext()) {
            String item = it.next();
            json.append('\"').append(Strings.escapeToJson(item)).append('\"');
            if (!it.hasNext()) continue;
            json.append(",");
        }
        json.append("]");
        return json.toString();
    }

    public static boolean isNotBlank(String s) {
        int codepoint;
        if (s == null || s.isEmpty()) {
            return false;
        }
        int length = s.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            if (Character.isWhitespace(codepoint)) continue;
            return true;
        }
        return false;
    }

    public static String random(int length) {
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = (char)(97 + ThreadLocalRandom.current().nextInt(26));
        }
        return new String(c);
    }
}

