/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.communication.ddagent.DroppingPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.util.Strings;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentFeaturesDiscovery
implements DroppingPolicy {
    private static final Logger log = LoggerFactory.getLogger(DDAgentFeaturesDiscovery.class);
    private static final JsonAdapter<Map<String, Object>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter(Types.newParameterizedType(Map.class, new Type[]{String.class, Object.class}));
    public static final String V3_ENDPOINT = "v0.3/traces";
    public static final String V4_ENDPOINT = "v0.4/traces";
    public static final String V5_ENDPOINT = "v0.5/traces";
    public static final String V6_METRICS_ENDPOINT = "v0.6/stats";
    public static final String V7_CONFIG_ENDPOINT = "v0.7/config";
    public static final String V01_DATASTREAMS_ENDPOINT = "v0.1/pipeline_stats";
    public static final String V2_EVP_PROXY_ENDPOINT = "evp_proxy/v2/";
    public static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    public static final String DEBUGGER_ENDPOINT = "debugger/v1/input";
    private static final long MIN_FEATURE_DISCOVERY_INTERVAL_MILLIS = 60000L;
    private final OkHttpClient client;
    private final HttpUrl agentBaseUrl;
    private final Recording discoveryTimer;
    private final String[] traceEndpoints;
    private final String[] metricsEndpoints = new String[]{"v0.6/stats"};
    private final String[] configEndpoints = new String[]{"v0.7/config"};
    private final boolean metricsEnabled;
    private final String[] dataStreamsEndpoints = new String[]{"v0.1/pipeline_stats"};
    private final String[] evpProxyEndpoints = new String[]{"evp_proxy/v2/"};
    private volatile String traceEndpoint;
    private volatile String metricsEndpoint;
    private volatile String dataStreamsEndpoint;
    private volatile boolean supportsLongRunning;
    private volatile boolean supportsDropping;
    private volatile String state;
    private volatile String configEndpoint;
    private volatile String debuggerEndpoint;
    private volatile String evpProxyEndpoint;
    private volatile String version;
    private long lastTimeDiscovered;

    public DDAgentFeaturesDiscovery(OkHttpClient client, Monitoring monitoring, HttpUrl agentUrl, boolean enableV05Traces, boolean metricsEnabled) {
        String[] stringArray;
        this.client = client;
        this.agentBaseUrl = agentUrl;
        this.metricsEnabled = metricsEnabled;
        if (enableV05Traces) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.traceEndpoints = stringArray;
        this.discoveryTimer = monitoring.newTimer("trace.agent.discovery.time");
    }

    private void reset() {
        this.traceEndpoint = null;
        this.metricsEndpoint = null;
        this.supportsDropping = false;
        this.supportsLongRunning = false;
        this.state = null;
        this.configEndpoint = null;
        this.debuggerEndpoint = null;
        this.dataStreamsEndpoint = null;
        this.evpProxyEndpoint = null;
        this.version = null;
        this.lastTimeDiscovered = 0L;
    }

    public void discover() {
        this.discoverIfOutdated(0L);
    }

    public void discoverIfOutdated() {
        this.discoverIfOutdated(this.getFeaturesDiscoveryMinDelayMillis());
    }

    protected long getFeaturesDiscoveryMinDelayMillis() {
        return 60000L;
    }

    private synchronized void discoverIfOutdated(long maxElapsedMs) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastTimeDiscovered;
        if (elapsed > maxElapsedMs) {
            this.doDiscovery();
            this.lastTimeDiscovered = now;
        }
    }

    private void doDiscovery() {
        this.reset();
        try (Recording recording = this.discoveryTimer.start();){
            boolean fallback = true;
            try (Response response = this.client.newCall(new Request.Builder().url(this.agentBaseUrl.resolve("info").url()).build()).execute();){
                if (response.isSuccessful()) {
                    fallback = !this.processInfoResponse(response.body().string());
                }
            }
            catch (Throwable error) {
                this.errorQueryingEndpoint("info", error);
            }
            if (fallback) {
                this.supportsDropping = false;
                this.supportsLongRunning = false;
                log.debug("Falling back to probing, client dropping will be disabled");
                this.metricsEndpoint = null;
            }
            if (null == this.traceEndpoint) {
                this.traceEndpoint = this.probeTracesEndpoint(this.traceEndpoints);
            } else if (this.state == null || this.state.isEmpty()) {
                this.probeTracesEndpoint(new String[]{this.traceEndpoint});
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("discovered traceEndpoint={}, metricsEndpoint={}, supportsDropping={}, supportsLongRunning={}, dataStreamsEndpoint={}, configEndpoint={}, evpProxyEndpoint={}", new Object[]{this.traceEndpoint, this.metricsEndpoint, this.supportsDropping, this.supportsLongRunning, this.dataStreamsEndpoint, this.evpProxyEndpoint, this.configEndpoint});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String probeTracesEndpoint(String[] endpoints) {
        String[] stringArray = endpoints;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            try (Response response = this.client.newCall(new Request.Builder().put(OkHttpUtils.msgpackRequestBodyOf(Collections.emptyList())).url(this.agentBaseUrl.resolve(candidate)).build()).execute();){
                if (response.code() != 404) {
                    this.state = response.header(DATADOG_AGENT_STATE);
                    String string = candidate;
                    return string;
                }
            }
            catch (IOException e) {
                this.errorQueryingEndpoint(candidate, e);
            }
            ++n2;
        }
        return V3_ENDPOINT;
    }

    private boolean processInfoResponse(String response) {
        try {
            Map<String, Object> map = RESPONSE_ADAPTER.fromJson(response);
            DDAgentFeaturesDiscovery.discoverStatsDPort(map);
            this.version = (String)map.get("version");
            HashSet endpoints = new HashSet((List)map.get("endpoints"));
            String foundMetricsEndpoint = null;
            if (this.metricsEnabled) {
                for (String endpoint : this.metricsEndpoints) {
                    if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                    foundMetricsEndpoint = endpoint;
                    break;
                }
            }
            this.metricsEndpoint = foundMetricsEndpoint;
            for (String endpoint : this.traceEndpoints) {
                if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                this.traceEndpoint = endpoint;
                break;
            }
            for (String endpoint : this.configEndpoints) {
                if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                this.configEndpoint = endpoint;
                break;
            }
            if (endpoints.contains(DEBUGGER_ENDPOINT) || endpoints.contains("/debugger/v1/input")) {
                this.debuggerEndpoint = DEBUGGER_ENDPOINT;
            }
            for (String endpoint : this.dataStreamsEndpoints) {
                if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                this.dataStreamsEndpoint = endpoint;
                break;
            }
            for (String endpoint : this.evpProxyEndpoints) {
                if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                this.evpProxyEndpoint = endpoint;
                break;
            }
            this.supportsLongRunning = Boolean.TRUE.equals(map.getOrDefault("long_running_spans", false));
            if (this.metricsEnabled) {
                Object canDrop = map.get("client_drop_p0s");
                this.supportsDropping = null != canDrop && ("true".equalsIgnoreCase(String.valueOf(canDrop)) || Boolean.TRUE.equals(canDrop));
            }
            try {
                this.state = Strings.sha256(response);
            }
            catch (NoSuchAlgorithmException ex) {
                log.debug("Failed to hash trace agent /info response. Will probe {}", (Object)this.traceEndpoint, (Object)ex);
            }
            return true;
        }
        catch (Throwable error) {
            log.debug("Error parsing trace agent /info response", error);
            return false;
        }
    }

    private static void discoverStatsDPort(Map<String, Object> info) {
        try {
            Map config = (Map)info.get("config");
            Object statsdPortObj = config.get("statsd_port");
            if (statsdPortObj == null) {
                log.debug("statsd_port missing from trace agent /info response");
                return;
            }
            int statsdPort = ((Number)statsdPortObj).intValue();
            DDAgentStatsDClientManager.setDefaultStatsDPort(statsdPort);
        }
        catch (Throwable ignore) {
            log.debug("statsd_port missing from trace agent /info response", ignore);
        }
    }

    public boolean supportsMetrics() {
        return this.metricsEnabled && null != this.metricsEndpoint;
    }

    public boolean supportsDebugger() {
        return this.debuggerEndpoint != null;
    }

    boolean supportsDropping() {
        return this.supportsDropping;
    }

    public boolean supportsLongRunning() {
        return this.supportsLongRunning;
    }

    public String getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public String getTraceEndpoint() {
        return this.traceEndpoint;
    }

    public String getDataStreamsEndpoint() {
        return this.dataStreamsEndpoint;
    }

    public String getEvpProxyEndpoint() {
        return this.evpProxyEndpoint;
    }

    public HttpUrl buildUrl(String endpoint) {
        return this.agentBaseUrl.resolve(endpoint);
    }

    public boolean supportsDataStreams() {
        return this.dataStreamsEndpoint != null;
    }

    public boolean supportsEvpProxy() {
        return this.evpProxyEndpoint != null;
    }

    public String getConfigEndpoint() {
        return this.configEndpoint;
    }

    public String getVersion() {
        return this.version;
    }

    private void errorQueryingEndpoint(String endpoint, Throwable t) {
        log.debug("Error querying {} at {}", new Object[]{endpoint, this.agentBaseUrl, t});
    }

    public String state() {
        return this.state;
    }

    @Override
    public boolean active() {
        return this.supportsMetrics() && this.supportsDropping;
    }
}

