/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConfigCollector {
    private static final Set<String> CONFIG_FILTER_LIST = new HashSet<String>(Arrays.asList("DD_API_KEY", "dd.api-key", "dd.profiling.api-key", "dd.profiling.apikey"));
    private static final ConfigCollector INSTANCE = new ConfigCollector();
    private static final AtomicReferenceFieldUpdater<ConfigCollector, Map> COLLECTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConfigCollector.class, Map.class, "collected");
    private volatile Map<String, Object> collected = new ConcurrentHashMap<String, Object>();

    public static ConfigCollector get() {
        return INSTANCE;
    }

    public void put(String key, Object value) {
        this.collected.put(key, ConfigCollector.filterConfigEntry(key, value));
    }

    public void putAll(Map<String, Object> keysAndValues) {
        ConcurrentHashMap<String, Object> merged = new ConcurrentHashMap<String, Object>(keysAndValues);
        merged.replaceAll(ConfigCollector::filterConfigEntry);
        while (true) {
            Map<String, Object> current = this.collected;
            current.forEach(merged::putIfAbsent);
            if (COLLECTED_UPDATER.compareAndSet(this, current, merged)) break;
            merged.keySet().retainAll(keysAndValues.keySet());
        }
    }

    public Map<String, Object> collect() {
        if (!this.collected.isEmpty()) {
            return COLLECTED_UPDATER.getAndSet(this, new ConcurrentHashMap());
        }
        return Collections.emptyMap();
    }

    private static Object filterConfigEntry(String key, Object value) {
        return CONFIG_FILTER_LIST.contains(key) ? "<hidden>" : value;
    }
}

