/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class Functions {
    public static final Function<String, UTF8BytesString> UTF8_ENCODE = UTF8BytesString::create;

    private Functions() {
    }

    public static <T> Function<?, T> newInstanceOf(Class<T> clazz) {
        return new NewInstance(clazz);
    }

    private static final class NewInstance<Object, T>
    implements Function<Object, T> {
        private final MethodHandle methodHandle;

        private NewInstance(Class<T> type) {
            try {
                this.methodHandle = MethodHandles.lookup().findConstructor(type, MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public T apply(Object input) {
            try {
                return (T)this.methodHandle.invoke();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static final class ToString<T>
    implements Function<T, String> {
        @Override
        public String apply(T key) {
            return key.toString();
        }
    }

    public static final class LowerCase
    implements Function<String, String> {
        public static final LowerCase INSTANCE = new LowerCase();

        @Override
        public String apply(String key) {
            return key.toLowerCase(Locale.ROOT);
        }
    }

    public static class SuffixJoin
    extends Join {
        public static final SuffixJoin ZERO = SuffixJoin.of("");

        public SuffixJoin(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            super(joiner, transformer);
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence specialisation) {
            return new Suffix(String.valueOf(this.joiner) + specialisation, this.transformer);
        }

        public static SuffixJoin of(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            return new SuffixJoin(joiner, transformer);
        }

        public static SuffixJoin of(CharSequence joiner) {
            return SuffixJoin.of(joiner, Function.identity());
        }
    }

    public static class PrefixJoin
    extends Join {
        public static final PrefixJoin ZERO = PrefixJoin.of("");

        public PrefixJoin(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            super(joiner, transformer);
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence specialisation) {
            return new Prefix(String.valueOf(specialisation) + this.joiner, this.transformer);
        }

        public static PrefixJoin of(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            return new PrefixJoin(joiner, transformer);
        }

        public static PrefixJoin of(String joiner) {
            return PrefixJoin.of(joiner, Function.identity());
        }
    }

    public static abstract class Join
    implements BiFunction<CharSequence, CharSequence, CharSequence> {
        protected final CharSequence joiner;
        protected final Function<CharSequence, CharSequence> transformer;

        protected Join(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            this.joiner = joiner;
            this.transformer = transformer;
        }

        @Override
        public CharSequence apply(CharSequence left, CharSequence right) {
            return UTF8BytesString.create(String.valueOf(left) + this.joiner + right);
        }

        public abstract Function<CharSequence, CharSequence> curry(CharSequence var1);
    }

    public static final class Prefix
    extends Concatenate
    implements Function<CharSequence, CharSequence> {
        private final CharSequence prefix;
        private final Function<CharSequence, CharSequence> transformer;

        public Prefix(CharSequence prefix, Function<CharSequence, CharSequence> transformer) {
            this.prefix = prefix;
            this.transformer = transformer;
        }

        public Prefix(CharSequence prefix) {
            this(prefix, Function.identity());
        }

        @Override
        public CharSequence apply(CharSequence key) {
            return this.concatenate(this.prefix, this.transformer.apply(key));
        }
    }

    public static final class Suffix
    extends Concatenate
    implements Function<CharSequence, CharSequence> {
        private final CharSequence suffix;
        private final Function<CharSequence, CharSequence> transformer;

        public Suffix(CharSequence suffix, Function<CharSequence, CharSequence> transformer) {
            this.suffix = suffix;
            this.transformer = transformer;
        }

        public Suffix(String suffix) {
            this(suffix, Function.identity());
        }

        @Override
        public CharSequence apply(CharSequence key) {
            return this.concatenate(this.transformer.apply(key), this.suffix);
        }
    }

    public static abstract class Concatenate {
        public CharSequence concatenate(CharSequence left, CharSequence right) {
            return UTF8BytesString.create(String.valueOf(left) + right);
        }
    }
}

