/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.FixedSizeCache;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;

final class FixedSizeWeakKeyCache<K, V>
implements DDCache<K, V> {
    private final int mask;
    private final WeakPair<K, V>[] elements;

    FixedSizeWeakKeyCache(int capacity) {
        int size = FixedSizeCache.calculateSize(capacity);
        this.elements = new WeakPair[size];
        this.mask = size - 1;
    }

    @Override
    public final V computeIfAbsent(K key, Function<K, ? extends V> producer) {
        V value;
        if (key == null) {
            return null;
        }
        int hash = System.identityHashCode(key);
        int h = hash - (hash << 7);
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            WeakPair<K, V> current;
            if ((current = this.elements[pos = h & this.mask]) == null || null == current.get()) {
                value = this.produceAndStoreValue(producer, hash, key, pos);
                break;
            }
            if (hash == current.hash && key.equals(current.get())) {
                value = current.value;
                break;
            }
            if (i == 3) {
                value = this.produceAndStoreValue(producer, hash, key, firstPos);
                break;
            }
            h = FixedSizeCache.rehash(h);
            ++i;
        }
        return value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
    }

    private V produceAndStoreValue(Function<K, ? extends V> producer, int hash, K key, int pos) {
        V value = producer.apply(key);
        this.elements[pos] = new WeakPair<K, V>(key, hash, value);
        return value;
    }

    static final class WeakPair<K, V>
    extends WeakReference<K> {
        final int hash;
        final V value;

        WeakPair(K key, int hash, @Nullable V value) {
            super(key);
            this.hash = hash;
            this.value = value;
        }
    }
}

