/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.config;

import ddtrot.dd.trace.api.civisibility.config.SkippableTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SkippableTestsSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkippableTestsSerializer.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    static final char FIELD_DELIMITER = ':';
    static final char RECORD_DELIMITER = ',';
    static final char ESCAPE_CHARACTER = '\\';

    public static String serialize(Collection<SkippableTest> skippableTests) {
        if (skippableTests == null || skippableTests.isEmpty()) {
            return "";
        }
        String uncompressed = skippableTests.stream().map(SkippableTestsSerializer::serialize).collect(Collectors.joining(String.valueOf(',')));
        byte[] compressed = SkippableTestsSerializer.gzip(uncompressed.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(compressed);
    }

    private static String serialize(SkippableTest test) {
        String suite = test.getSuite();
        String name = test.getName();
        String parameters = test.getParameters();
        int expectedLength = suite.length() + name.length() + (parameters != null ? parameters.length() : 0);
        StringBuilder sb = new StringBuilder(expectedLength);
        SkippableTestsSerializer.appendEscaped(suite, sb);
        sb.append(':');
        SkippableTestsSerializer.appendEscaped(name, sb);
        if (parameters != null && !parameters.isEmpty()) {
            sb.append(':');
            SkippableTestsSerializer.appendEscaped(parameters, sb);
        }
        return sb.toString();
    }

    private static void appendEscaped(String s, StringBuilder sb) {
        int codepoint;
        if (s == null || s.isEmpty()) {
            return;
        }
        int l = s.length();
        block3: for (int i = 0; i < l; i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            switch (codepoint) {
                case 44: 
                case 58: 
                case 92: {
                    sb.append('\\').appendCodePoint(codepoint);
                    continue block3;
                }
                default: {
                    sb.appendCodePoint(codepoint);
                }
            }
        }
    }

    public static Collection<SkippableTest> deserialize(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] compressed = Base64.getDecoder().decode(s);
        String uncompressed = new String(SkippableTestsSerializer.gunzip(compressed), CHARSET);
        return SkippableTestsSerializer.deserializeDecompressed(uncompressed);
    }

    private static Collection<SkippableTest> deserializeDecompressed(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SkippableTest> tests = new ArrayList<SkippableTest>();
        String[] tokens = new String[3];
        int tokenIdx = 0;
        StringBuilder sb = new StringBuilder();
        int l = s.length();
        int i = 0;
        block5: while (i < l) {
            int codepoint = s.codePointAt(i);
            i += Character.charCount(codepoint);
            switch (codepoint) {
                case 92: {
                    int nextCodepoint = s.codePointAt(i);
                    if (nextCodepoint == 92 || nextCodepoint == 58 || nextCodepoint == 44) {
                        sb.appendCodePoint(nextCodepoint);
                        i += Character.charCount(nextCodepoint);
                        continue block5;
                    }
                    sb.appendCodePoint(codepoint);
                    continue block5;
                }
                case 58: {
                    tokens[tokenIdx++] = sb.toString();
                    sb.setLength(0);
                    continue block5;
                }
                case 44: {
                    tokens[tokenIdx] = sb.toString();
                    tests.add(new SkippableTest(tokens[0], tokens[1], tokens[2], null));
                    sb.setLength(0);
                    tokens[tokenIdx] = null;
                    tokenIdx = 0;
                    continue block5;
                }
            }
            sb.appendCodePoint(codepoint);
        }
        tokens[tokenIdx] = sb.toString();
        tests.add(new SkippableTest(tokens[0], tokens[1], tokens[2], null));
        return tests;
    }

    private static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);){
            gzipOutputStream.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            LOGGER.error("Error while compressing skippable tests data", (Throwable)e);
            return new byte[0];
        }
        return baos.toByteArray();
    }

    private static byte[] gunzip(byte[] bytes) {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            int read;
            while ((read = gzipInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while decompressing skippable tests data", (Throwable)e);
            return new byte[0];
        }
        return baos.toByteArray();
    }
}

