/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import ddtrot.dd.trace.api.metrics.CoreCounter;
import ddtrot.dd.trace.api.metrics.SpanMetricRegistryImpl;
import ddtrot.dd.trace.api.metrics.SpanMetrics;
import ddtrot.dd.trace.api.metrics.SpanMetricsImpl;
import ddtrot.dd.trace.api.telemetry.MetricCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class CoreMetricCollector
implements MetricCollector<CoreMetric> {
    private static final String METRIC_NAMESPACE = "tracers";
    private static final CoreMetricCollector INSTANCE = new CoreMetricCollector();
    private final SpanMetricRegistryImpl spanMetricRegistry = SpanMetricRegistryImpl.getInstance();
    private final BlockingQueue<CoreMetric> metricsQueue = new ArrayBlockingQueue<CoreMetric>(1024);

    public static CoreMetricCollector getInstance() {
        return INSTANCE;
    }

    private CoreMetricCollector() {
    }

    @Override
    public void prepareMetrics() {
        for (SpanMetrics spanMetric : this.spanMetricRegistry.getSpanMetrics()) {
            CoreMetric metric;
            CoreCounter counter;
            long value;
            SpanMetricsImpl spanMetricsImpl = (SpanMetricsImpl)spanMetric;
            String tag = spanMetricsImpl.getInstrumentationName();
            Iterator<CoreCounter> iterator = spanMetricsImpl.getCounters().iterator();
            while (iterator.hasNext() && ((value = (counter = iterator.next()).getValueAndReset()) == 0L || this.metricsQueue.offer(metric = new CoreMetric(METRIC_NAMESPACE, true, counter.getName(), "count", (Number)value, tag)))) {
            }
        }
    }

    @Override
    public Collection<CoreMetric> drain() {
        if (this.metricsQueue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CoreMetric> drained = new ArrayList<CoreMetric>(this.metricsQueue.size());
        this.metricsQueue.drainTo(drained);
        return drained;
    }

    public static class CoreMetric
    extends MetricCollector.Metric {
        public CoreMetric(String namespace, boolean common, String metricName, String type, Number value, String tag) {
            super(namespace, common, metricName, type, value, tag);
        }
    }
}

