/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.writer.ddintake;

import datadog.trace.api.WellKnownTags;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CiTestCycleMapperV1
implements RemoteMapper {
    private static final byte[] VERSION = "version".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA = "metadata".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_ASTERISK = "*".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENTS = "events".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ENV = "env".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    private static final UTF8BytesString SPAN_TYPE = UTF8BytesString.create("span");
    private static final Collection<String> DEFAULT_TOP_LEVEL_TAGS = Arrays.asList("test_session_id", "test_module_id", "test_suite_id");
    private final WellKnownTags wellKnownTags;
    private final Collection<String> topLevelTags;
    private final int size;
    private final GrowableBuffer headerBuffer;
    private final MsgPackWriter headerWriter;
    private int eventCount = 0;
    private final MetaWriter metaWriter = new MetaWriter();

    public CiTestCycleMapperV1(WellKnownTags wellKnownTags) {
        this(wellKnownTags, DEFAULT_TOP_LEVEL_TAGS, 0x500000);
    }

    private CiTestCycleMapperV1(WellKnownTags wellKnownTags, Collection<String> topLevelTags, int size) {
        this.wellKnownTags = wellKnownTags;
        this.topLevelTags = topLevelTags;
        this.size = size;
        this.headerBuffer = new GrowableBuffer(16);
        this.headerWriter = new MsgPackWriter(this.headerBuffer);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        for (CoreSpan<?> span : trace) {
            int version;
            Long parentId;
            Long spanId;
            Long traceId;
            UTF8BytesString type;
            int topLevelTagsCount = 0;
            for (String topLevelTag : this.topLevelTags) {
                if (span.getTag(topLevelTag) == null) continue;
                ++topLevelTagsCount;
            }
            if (InternalSpanTypes.TEST.equals(span.getType())) {
                type = InternalSpanTypes.TEST;
                traceId = span.getTraceId().toLong();
                spanId = span.getSpanId();
                parentId = span.getParentId();
                version = topLevelTagsCount > 0 ? 2 : 1;
            } else if (InternalSpanTypes.TEST_SUITE_END.equals(span.getType())) {
                type = InternalSpanTypes.TEST_SUITE_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else if (InternalSpanTypes.TEST_MODULE_END.equals(span.getType())) {
                type = InternalSpanTypes.TEST_MODULE_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else if (InternalSpanTypes.TEST_SESSION_END.equals(span.getType())) {
                type = InternalSpanTypes.TEST_SESSION_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else {
                type = SPAN_TYPE;
                traceId = span.getTraceId().toLong();
                spanId = span.getSpanId();
                parentId = span.getParentId();
                version = 1;
            }
            int contentChildrenCount = 8 + (traceId != null ? 1 : 0) + (spanId != null ? 1 : 0) + (parentId != null ? 1 : 0) + topLevelTagsCount;
            writable.startMap(3);
            writable.writeUTF8(TYPE);
            writable.writeUTF8(type);
            writable.writeUTF8(VERSION);
            writable.writeInt(version);
            writable.writeUTF8(CONTENT);
            writable.startMap(contentChildrenCount);
            if (traceId != null) {
                writable.writeUTF8(TRACE_ID);
                writable.writeUnsignedLong(traceId);
            }
            if (spanId != null) {
                writable.writeUTF8(SPAN_ID);
                writable.writeUnsignedLong(spanId);
            }
            if (parentId != null) {
                writable.writeUTF8(PARENT_ID);
                writable.writeUnsignedLong(parentId);
            }
            for (String topLevelTag : this.topLevelTags) {
                Object tagValue = span.getTag(topLevelTag);
                if (tagValue == null) continue;
                writable.writeString(topLevelTag, null);
                if (tagValue instanceof Number) {
                    writable.writeObject(tagValue, null);
                } else {
                    writable.writeObjectString(tagValue, null);
                }
                span.removeTag(topLevelTag);
            }
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
        this.eventCount += trace.size();
    }

    private void writeHeader() {
        this.headerWriter.startMap(3);
        this.headerWriter.writeUTF8(VERSION);
        this.headerWriter.writeInt(1);
        this.headerWriter.writeUTF8(METADATA);
        this.headerWriter.startMap(1);
        this.headerWriter.writeUTF8(METADATA_ASTERISK);
        this.headerWriter.startMap(3);
        this.headerWriter.writeUTF8(ENV);
        this.headerWriter.writeUTF8(this.wellKnownTags.getEnv());
        this.headerWriter.writeUTF8(RUNTIME_ID);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeId());
        this.headerWriter.writeUTF8(LANGUAGE);
        this.headerWriter.writeUTF8(this.wellKnownTags.getLanguage());
        this.headerWriter.writeUTF8(EVENTS);
        this.headerWriter.startArray(this.eventCount);
    }

    @Override
    public Payload newPayload() {
        this.writeHeader();
        return new PayloadV1().withHeader(this.headerBuffer.slice());
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
        this.eventCount = 0;
    }

    @Override
    public String endpoint() {
        return "citestcycle/v1";
    }

    private static class PayloadV1
    extends Payload {
        ByteBuffer header = null;

        private PayloadV1() {
        }

        PayloadV1 withHeader(ByteBuffer header) {
            this.header = header;
            return this;
        }

        @Override
        public int sizeInBytes() {
            if (this.traceCount() == 0) {
                return this.msgpackMapHeaderSize(0);
            }
            int size = this.body.remaining();
            if (this.header != null) {
                size += this.header.remaining();
            }
            return size;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer emptyDict = this.msgpackMapHeader(0);
                while (emptyDict.hasRemaining()) {
                    channel.write(emptyDict);
                }
            } else {
                if (this.header != null) {
                    while (this.header.hasRemaining()) {
                        channel.write(this.header);
                    }
                }
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            if (this.traceCount() == 0) {
                return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.msgpackMapHeader(0)));
            }
            if (this.header != null) {
                return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.header, this.body));
            }
            return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.body));
        }
    }

    private static final class MetaWriter
    implements MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1);
            int metricsSize = 0;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObjectString(entry.getValue(), null);
            }
        }
    }
}

