/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.Platform;
import datadog.trace.api.ProductActivation;
import datadog.trace.api.ResolverCacheConfig;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import ddtrot.dd.trace.util.CollectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class InstrumenterConfig {
    private final ConfigProvider configProvider;
    private final boolean integrationsEnabled;
    private final boolean traceEnabled;
    private final boolean traceOtelEnabled;
    private final boolean logs128bTraceIdEnabled;
    private final boolean profilingEnabled;
    private final boolean ciVisibilityEnabled;
    private final ProductActivation appSecActivation;
    private final ProductActivation iastActivation;
    private final boolean usmEnabled;
    private final boolean telemetryEnabled;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final Set<String> traceThreadPoolExecutorsExclude;
    private final String jdbcPreparedStatementClassName;
    private final String jdbcConnectionClassName;
    private final boolean directAllocationProfilingEnabled;
    private final List<String> excludedClasses;
    private final String excludedClassesFile;
    private final Set<String> excludedClassLoaders;
    private final List<String> excludedCodeSources;
    private final ResolverCacheConfig resolverCacheConfig;
    private final String resolverCacheDir;
    private final boolean resolverNamesAreUnique;
    private final boolean resolverUseLoadClass;
    private final int resolverResetInterval;
    private final boolean runtimeContextFieldInjection;
    private final boolean serialVersionUIDFieldInjection;
    private final String traceAnnotations;
    private final String traceMethods;
    private final String measureMethods;
    private final boolean internalExitOnFailure;
    private final boolean legacyInstallerEnabled;
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final InstrumenterConfig INSTANCE = new InstrumenterConfig(Platform.isNativeImageBuilder() ? ConfigProvider.withoutCollector() : ConfigProvider.getInstance());

    private InstrumenterConfig() {
        this(ConfigProvider.createDefault());
    }

    InstrumenterConfig(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.integrationsEnabled = configProvider.getBoolean("integrations.enabled", true, new String[0]);
        this.traceEnabled = configProvider.getBoolean("trace.enabled", true, new String[0]);
        this.traceOtelEnabled = configProvider.getBoolean("trace.otel.enabled", false, new String[0]);
        this.logs128bTraceIdEnabled = configProvider.getBoolean("trace.128.bit.traceid.logging.enabled", false, new String[0]);
        if (!Platform.isNativeImageBuilder()) {
            this.profilingEnabled = configProvider.getBoolean("profiling.enabled", false, new String[0]);
            this.ciVisibilityEnabled = configProvider.getBoolean("civisibility.enabled", false, new String[0]);
            this.appSecActivation = ProductActivation.fromString(configProvider.getStringNotEmpty("appsec.enabled", "inactive", new String[0]));
            this.iastActivation = ProductActivation.fromString(configProvider.getStringNotEmpty("iast.enabled", "false", new String[0]));
            this.usmEnabled = configProvider.getBoolean("usm.enabled", false, new String[0]);
            this.telemetryEnabled = configProvider.getBoolean("instrumentation.telemetry.enabled", true, new String[0]);
        } else {
            this.profilingEnabled = false;
            this.ciVisibilityEnabled = false;
            this.appSecActivation = ProductActivation.FULLY_DISABLED;
            this.iastActivation = ProductActivation.FULLY_DISABLED;
            this.telemetryEnabled = false;
            this.usmEnabled = false;
        }
        this.traceExecutorsAll = configProvider.getBoolean("trace.executors.all", false, new String[0]);
        this.traceExecutors = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.executors"));
        this.traceThreadPoolExecutorsExclude = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.thread-pool-executors.exclude"));
        this.jdbcPreparedStatementClassName = configProvider.getString("trace.jdbc.prepared.statement.class.name", "", new String[0]);
        this.jdbcConnectionClassName = configProvider.getString("trace.jdbc.connection.class.name", "", new String[0]);
        this.directAllocationProfilingEnabled = configProvider.getBoolean("profiling.directallocation.enabled", false, new String[0]);
        this.excludedClasses = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.classes.exclude"));
        this.excludedClassesFile = configProvider.getString("trace.classes.exclude.file");
        this.excludedClassLoaders = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.classloaders.exclude"));
        this.excludedCodeSources = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.codesources.exclude"));
        this.resolverCacheConfig = configProvider.getEnum("resolver.cache.config", ResolverCacheConfig.class, ResolverCacheConfig.MEMOS);
        this.resolverCacheDir = configProvider.getString("resolver.cache.dir");
        this.resolverNamesAreUnique = configProvider.getBoolean("resolver.names.are.unique", false, new String[0]);
        this.resolverUseLoadClass = configProvider.getBoolean("resolver.use.loadclass", true, new String[0]);
        this.resolverResetInterval = Platform.isNativeImageBuilder() ? 0 : configProvider.getInteger("resolver.reset.interval", 300, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean("trace.runtime.context.field.injection", true, new String[0]);
        this.serialVersionUIDFieldInjection = configProvider.getBoolean("trace.serialversionuid.field.injection", true, new String[0]);
        this.traceAnnotations = configProvider.getString("trace.annotations", ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceMethods = configProvider.getString("trace.methods", ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]);
        this.measureMethods = configProvider.getString("measure.methods", "", new String[0]);
        this.internalExitOnFailure = configProvider.getBoolean("trace.internal.exit.on.failure", false, new String[0]);
        this.legacyInstallerEnabled = configProvider.getBoolean("legacy.installer.enabled", false, new String[0]);
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public boolean isIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".enabled", defaultEnabled);
    }

    public boolean isIntegrationShortcutMatchingEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".matching.shortcut.enabled", defaultEnabled);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isTraceOtelEnabled() {
        return this.traceOtelEnabled;
    }

    public boolean isLogs128bTraceIdEnabled() {
        return this.logs128bTraceIdEnabled;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public boolean isCiVisibilityEnabled() {
        return this.ciVisibilityEnabled;
    }

    public ProductActivation getAppSecActivation() {
        return this.appSecActivation;
    }

    public ProductActivation getIastActivation() {
        return this.iastActivation;
    }

    public boolean isUsmEnabled() {
        return this.usmEnabled;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public Set<String> getTraceThreadPoolExecutorsExclude() {
        return this.traceThreadPoolExecutorsExclude;
    }

    public String getJdbcPreparedStatementClassName() {
        return this.jdbcPreparedStatementClassName;
    }

    public String getJdbcConnectionClassName() {
        return this.jdbcConnectionClassName;
    }

    public boolean isDirectAllocationProfilingEnabled() {
        return this.directAllocationProfilingEnabled;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public String getExcludedClassesFile() {
        return this.excludedClassesFile;
    }

    public Set<String> getExcludedClassLoaders() {
        return this.excludedClassLoaders;
    }

    public List<String> getExcludedCodeSources() {
        return this.excludedCodeSources;
    }

    public int getResolverNoMatchesSize() {
        return this.resolverCacheConfig.noMatchesSize();
    }

    public boolean isResolverMemoizingEnabled() {
        return this.resolverCacheConfig.memoPoolSize() > 0;
    }

    public int getResolverMemoPoolSize() {
        return this.resolverCacheConfig.memoPoolSize();
    }

    public boolean isResolverOutliningEnabled() {
        return this.resolverCacheConfig.outlinePoolSize() > 0;
    }

    public int getResolverOutlinePoolSize() {
        return this.resolverCacheConfig.outlinePoolSize();
    }

    public int getResolverTypePoolSize() {
        return this.resolverCacheConfig.typePoolSize();
    }

    public String getResolverCacheDir() {
        return this.resolverCacheDir;
    }

    public boolean isResolverNamesAreUnique() {
        return this.resolverNamesAreUnique;
    }

    public boolean isResolverUseLoadClass() {
        return this.resolverUseLoadClass;
    }

    public int getResolverResetInterval() {
        return this.resolverResetInterval;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isSerialVersionUIDFieldInjection() {
        return this.serialVersionUIDFieldInjection;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public String getMeasureMethods() {
        return this.measureMethods;
    }

    public boolean isInternalExitOnFailure() {
        return this.internalExitOnFailure;
    }

    public boolean isLegacyInstallerEnabled() {
        return this.legacyInstallerEnabled;
    }

    public boolean isLegacyInstrumentationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public static InstrumenterConfig get() {
        return INSTANCE;
    }

    public String toString() {
        return "InstrumenterConfig{integrationsEnabled=" + this.integrationsEnabled + ", traceEnabled=" + this.traceEnabled + ", traceOtelEnabled=" + this.traceOtelEnabled + ", logs128bTraceIdEnabled=" + this.logs128bTraceIdEnabled + ", profilingEnabled=" + this.profilingEnabled + ", ciVisibilityEnabled=" + this.ciVisibilityEnabled + ", appSecActivation=" + (Object)((Object)this.appSecActivation) + ", iastActivation=" + (Object)((Object)this.iastActivation) + ", usmEnabled=" + this.usmEnabled + ", telemetryEnabled=" + this.telemetryEnabled + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", jdbcPreparedStatementClassName='" + this.jdbcPreparedStatementClassName + '\'' + ", jdbcConnectionClassName='" + this.jdbcConnectionClassName + '\'' + ", excludedClasses=" + this.excludedClasses + ", excludedClassesFile=" + this.excludedClassesFile + ", excludedClassLoaders=" + this.excludedClassLoaders + ", excludedCodeSources=" + this.excludedCodeSources + ", resolverCacheConfig=" + (Object)((Object)this.resolverCacheConfig) + ", resolverCacheDir=" + this.resolverCacheDir + ", resolverNamesAreUnique=" + this.resolverNamesAreUnique + ", resolverUseLoadClass=" + this.resolverUseLoadClass + ", resolverResetInterval=" + this.resolverResetInterval + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", serialVersionUIDFieldInjection=" + this.serialVersionUIDFieldInjection + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceMethods='" + this.traceMethods + '\'' + ", measureMethods= '" + this.measureMethods + '\'' + ", internalExitOnFailure=" + this.internalExitOnFailure + ", legacyInstallerEnabled=" + this.legacyInstallerEnabled + '}';
    }
}

