/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTrace;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.CoreTracer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.PendingTraceBuffer;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
implements AgentTrace,
PendingTraceBuffer.Element {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private static final List<DDSpan> EMPTY = new ArrayList<DDSpan>(0);
    private final CoreTracer tracer;
    private final DDTraceId traceId;
    private final PendingTraceBuffer pendingTraceBuffer;
    private final TimeSource timeSource;
    private final boolean strictTraceWrites;
    private final HealthMetrics healthMetrics;
    private final CoreTracer.ConfigSnapshot traceConfig;
    private final ConcurrentLinkedDeque<DDSpan> spans;
    private volatile int completedSpanCount = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> COMPLETED_SPAN_COUNT = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "completedSpanCount");
    private volatile int pendingReferenceCount = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> PENDING_REFERENCE_COUNT = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "pendingReferenceCount");
    private volatile int isEnqueued = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> IS_ENQUEUED = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "isEnqueued");
    private volatile int longRunningTrackedState = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> LONG_RUNNING_STATE = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "longRunningTrackedState");
    private volatile long runningTraceStartTimeNano = 0L;
    private static final AtomicLongFieldUpdater<PendingTrace> RUNNING_TRACE_START_TIME_NANO = AtomicLongFieldUpdater.newUpdater(PendingTrace.class, "runningTraceStartTimeNano");
    private volatile long lastWriteTimeNano = 0L;
    private static final AtomicLongFieldUpdater<PendingTrace> LAST_WRITE_TIME_NANO = AtomicLongFieldUpdater.newUpdater(PendingTrace.class, "lastWriteTimeNano");
    private volatile DDSpan rootSpan = null;
    private static final AtomicReferenceFieldUpdater<PendingTrace, DDSpan> ROOT_SPAN = AtomicReferenceFieldUpdater.newUpdater(PendingTrace.class, DDSpan.class, "rootSpan");
    private volatile boolean rootSpanWritten = false;
    private volatile long lastReferenced = 0L;
    private volatile long endToEndStartTime;
    private static final AtomicLongFieldUpdater<PendingTrace> END_TO_END_START_TIME = AtomicLongFieldUpdater.newUpdater(PendingTrace.class, "endToEndStartTime");

    private PendingTrace(@Nonnull CoreTracer tracer, @Nonnull DDTraceId traceId, @Nonnull PendingTraceBuffer pendingTraceBuffer, @Nonnull TimeSource timeSource, CoreTracer.ConfigSnapshot traceConfig, boolean strictTraceWrites, HealthMetrics healthMetrics) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.pendingTraceBuffer = pendingTraceBuffer;
        this.timeSource = timeSource;
        this.traceConfig = traceConfig != null ? traceConfig : tracer.captureTraceConfig();
        this.strictTraceWrites = strictTraceWrites;
        this.healthMetrics = healthMetrics;
        this.spans = new ConcurrentLinkedDeque();
    }

    CoreTracer getTracer() {
        return this.tracer;
    }

    TraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    String mapServiceName(String serviceName) {
        return this.traceConfig.getServiceMapping().getOrDefault(serviceName, serviceName);
    }

    public long getCurrentTimeNano() {
        long nanoTicks;
        this.lastReferenced = nanoTicks = this.timeSource.getNanoTicks();
        return this.tracer.getTimeWithNanoTicks(nanoTicks);
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public void touch() {
        this.lastReferenced = this.timeSource.getNanoTicks();
    }

    @Override
    public boolean lastReferencedNanosAgo(long nanos) {
        long currentNanoTicks = this.timeSource.getNanoTicks();
        long age = currentNanoTicks - this.lastReferenced;
        return nanos < age;
    }

    void registerSpan(DDSpan span) {
        ROOT_SPAN.compareAndSet(this, null, span);
        PENDING_REFERENCE_COUNT.incrementAndGet(this);
        this.healthMetrics.onCreateSpan();
        if (this.pendingTraceBuffer.longRunningSpansEnabled()) {
            this.spans.addFirst(span);
            this.trackRunningTrace(span);
        }
    }

    void trackRunningTrace(DDSpan span) {
        if (!this.compareAndSetLongRunningState(0, 1)) {
            return;
        }
        RUNNING_TRACE_START_TIME_NANO.set(this, span.getStartTime());
        this.pendingTraceBuffer.enqueue(this);
    }

    public Integer evaluateSamplingPriority() {
        DDSpan span = this.spans.peek();
        if (span == null) {
            return null;
        }
        Integer prio = span.getSamplingPriority();
        if (prio == null) {
            prio = span.forceSamplingDecision();
        }
        return prio;
    }

    public boolean compareAndSetLongRunningState(int expected, int newState) {
        return LONG_RUNNING_STATE.compareAndSet(this, expected, newState);
    }

    boolean empty() {
        return 0 >= COMPLETED_SPAN_COUNT.get(this) + PENDING_REFERENCE_COUNT.get(this);
    }

    PublishState onPublish(DDSpan span) {
        if (!this.pendingTraceBuffer.longRunningSpansEnabled()) {
            this.spans.addFirst(span);
        }
        this.healthMetrics.onFinishSpan();
        COMPLETED_SPAN_COUNT.incrementAndGet(this);
        return this.decrementRefAndMaybeWrite(span == this.getRootSpan());
    }

    @Override
    public DDSpan getRootSpan() {
        return this.rootSpan;
    }

    @Override
    public long oldestFinishedTime() {
        long oldest = Long.MAX_VALUE;
        for (DDSpan span : this.spans) {
            if (!span.isFinished()) continue;
            oldest = Math.min(oldest, span.getStartTime() + span.getDurationNano());
        }
        return oldest;
    }

    @Override
    public void registerContinuation(AgentScope.Continuation continuation) {
        PENDING_REFERENCE_COUNT.incrementAndGet(this);
    }

    @Override
    public void cancelContinuation(AgentScope.Continuation continuation) {
        this.decrementRefAndMaybeWrite(false);
        this.healthMetrics.onCancelContinuation();
    }

    private PublishState decrementRefAndMaybeWrite(boolean isRootSpan) {
        int count = PENDING_REFERENCE_COUNT.decrementAndGet(this);
        if (this.strictTraceWrites && count < 0) {
            throw new IllegalStateException("Pending reference count " + count + " is negative");
        }
        int partialFlushMinSpans = this.tracer.getPartialFlushMinSpans();
        if (count == 0 && (this.strictTraceWrites || !this.rootSpanWritten)) {
            this.write();
            return PublishState.WRITTEN;
        }
        if (isRootSpan) {
            this.pendingTraceBuffer.enqueue(this);
            return PublishState.ROOT_BUFFERED;
        }
        if (0 < partialFlushMinSpans && partialFlushMinSpans < this.size()) {
            this.partialFlush();
            return PublishState.PARTIAL_FLUSH;
        }
        if (this.rootSpanWritten) {
            this.pendingTraceBuffer.enqueue(this);
            return PublishState.BUFFERED;
        }
        return PublishState.PENDING;
    }

    private void partialFlush() {
        int size = this.write(true);
        this.healthMetrics.onPartialFlush(size);
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> wrote partial trace of size {}", (Object)this.traceId, (Object)size);
        }
    }

    @Override
    public void write() {
        this.write(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(boolean isPartial) {
        if (!this.spans.isEmpty()) {
            try (Recording recording = this.tracer.writeTimer();){
                List<DDSpan> trace;
                int completedSpans = 0;
                PendingTrace pendingTrace = this;
                synchronized (pendingTrace) {
                    boolean writeRunningSpans;
                    if (!isPartial) {
                        this.rootSpanWritten = true;
                    }
                    int size = this.size();
                    boolean bl = writeRunningSpans = 3 == LONG_RUNNING_STATE.get(this);
                    if (writeRunningSpans) {
                        size += this.pendingReferenceCount;
                    }
                    if (!(size <= 0 || isPartial && size <= this.tracer.getPartialFlushMinSpans())) {
                        trace = new ArrayList<DDSpan>(size);
                        completedSpans = this.enqueueSpansToWrite(trace, writeRunningSpans);
                    } else {
                        trace = EMPTY;
                    }
                }
                if (!trace.isEmpty()) {
                    COMPLETED_SPAN_COUNT.addAndGet(this, -completedSpans);
                    this.tracer.write(trace);
                    this.healthMetrics.onCreateTrace();
                    int n = completedSpans;
                    return n;
                }
            }
        }
        return 0;
    }

    public int enqueueSpansToWrite(List<DDSpan> trace, boolean writeRunningSpans) {
        int completedSpans = 0;
        boolean runningSpanSeen = false;
        long firstRunningSpanID = 0L;
        long nowNano = 0L;
        if (writeRunningSpans) {
            nowNano = this.getCurrentTimeNano();
            this.setLastWriteTime(nowNano);
        }
        DDSpan span = this.spans.pollFirst();
        while (null != span) {
            if (runningSpanSeen && span.getSpanId() == firstRunningSpanID) {
                this.spans.addFirst(span);
                break;
            }
            if (span.isFinished()) {
                trace.add(span);
                ++completedSpans;
            } else {
                this.spans.add(span);
                if (!runningSpanSeen) {
                    runningSpanSeen = true;
                    firstRunningSpanID = span.getSpanId();
                }
                if (writeRunningSpans) {
                    span.setLongRunningVersion((int)TimeUnit.NANOSECONDS.toMillis(nowNano - span.getStartTime()));
                    trace.add(span);
                }
            }
            span = this.spans.pollFirst();
        }
        return completedSpans;
    }

    public int size() {
        return this.completedSpanCount;
    }

    public void beginEndToEnd() {
        this.beginEndToEnd(this.getCurrentTimeNano());
    }

    void beginEndToEnd(long endToEndStartTime) {
        END_TO_END_START_TIME.compareAndSet(this, 0L, endToEndStartTime);
    }

    public long getEndToEndStartTime() {
        return this.endToEndStartTime;
    }

    public long getLastWriteTime() {
        return LAST_WRITE_TIME_NANO.get(this);
    }

    public long getRunningTraceStartTime() {
        return RUNNING_TRACE_START_TIME_NANO.get(this);
    }

    public void setLastWriteTime(long now) {
        LAST_WRITE_TIME_NANO.set(this, now);
    }

    @Override
    public boolean setEnqueued(boolean enqueued) {
        int expected = enqueued ? 0 : 1;
        return IS_ENQUEUED.compareAndSet(this, expected, 1 - expected);
    }

    @Override
    public boolean writeOnBufferFull() {
        return !this.compareAndSetLongRunningState(1, -1);
    }

    public static long getDurationNano(CoreSpan<?> span) {
        long duration = span.getDurationNano();
        if (duration > 0L) {
            return duration;
        }
        if (!(span instanceof DDSpan)) {
            return duration;
        }
        DDSpan ddSpan = (DDSpan)span;
        PendingTrace trace = ddSpan.context().getTrace();
        return trace.getLastWriteTime() - span.getStartTime();
    }

    public void setSamplingPriorityIfNecessary() {
        if (this.traceConfig.sampler instanceof PrioritySampler && this.rootSpan != null && this.rootSpan.context().getSamplingPriority() == -128) {
            ((PrioritySampler)((Object)this.traceConfig.sampler)).setSamplingPriority(this.rootSpan);
        }
    }

    public boolean sample(DDSpan spanToSample) {
        return this.traceConfig.sampler.sample(spanToSample);
    }

    static enum PublishState {
        WRITTEN,
        PARTIAL_FLUSH,
        ROOT_BUFFERED,
        BUFFERED,
        PENDING;

    }

    static class Factory {
        private final CoreTracer tracer;
        private final PendingTraceBuffer pendingTraceBuffer;
        private final TimeSource timeSource;
        private final boolean strictTraceWrites;
        private final HealthMetrics healthMetrics;

        Factory(CoreTracer tracer, PendingTraceBuffer pendingTraceBuffer, TimeSource timeSource, boolean strictTraceWrites, HealthMetrics healthMetrics) {
            this.tracer = tracer;
            this.pendingTraceBuffer = pendingTraceBuffer;
            this.timeSource = timeSource;
            this.strictTraceWrites = strictTraceWrites;
            this.healthMetrics = healthMetrics;
        }

        PendingTrace create(@Nonnull DDTraceId traceId) {
            return this.create(traceId, null);
        }

        PendingTrace create(@Nonnull DDTraceId traceId, CoreTracer.ConfigSnapshot traceConfig) {
            return new PendingTrace(this.tracer, traceId, this.pendingTraceBuffer, this.timeSource, traceConfig, this.strictTraceWrites, this.healthMetrics);
        }
    }
}

