/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DD64bTraceId;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XRayHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(XRayHttpCodec.class);
    static final String X_AMZN_TRACE_ID = "X-Amzn-Trace-Id";
    static final String ROOT = "Root";
    static final String PARENT = "Parent";
    static final String SAMPLED = "Sampled";
    static final String SELF = "Self";
    static final String ROOT_PREFIX = "Root=1-";
    static final String TRACE_ID_PADDING = "-00000000";
    static final String PARENT_PREFIX = "Parent=";
    static final String SAMPLED_PREFIX = "Sampled=";
    static final String SELF_PREFIX = "Self=";
    static final String ORIGIN_PREFIX = "_dd.origin=";
    static final int ROOT_PREAMBLE = "Root=1-".length() + 8;
    static final String E2E_START_KEY = "t0";
    static final String E2E_START_PREFIX = "t0=";
    static final int MAX_ADDITIONAL_BYTES = 256;

    private XRayHttpCodec() {
    }

    public static HttpCodec.Injector newInjector(Map<String, String> invertedBaggageMapping) {
        return new Injector(invertedBaggageMapping);
    }

    public static HttpCodec.Extractor newExtractor(Config config, Supplier<TraceConfig> traceConfigSupplier) {
        return new TagContextExtractor(traceConfigSupplier, () -> new XRayContextInterpreter(config));
    }

    static class XRayContextInterpreter
    extends ContextInterpreter {
        private XRayContextInterpreter(Config config) {
            super(config);
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            try {
                String mappedKey;
                char first = Character.toLowerCase(key.charAt(0));
                switch (first) {
                    case 'x': {
                        if (XRayHttpCodec.X_AMZN_TRACE_ID.equalsIgnoreCase(key)) {
                            XRayContextInterpreter.handleXRayTraceHeader(this, value);
                            return true;
                        }
                        if (!this.handledXForwarding(key, value)) break;
                        return true;
                    }
                    case 'f': {
                        if (!this.handledForwarding(key, value)) break;
                        return true;
                    }
                    case 'u': {
                        if (!this.handledUserAgent(key, value)) break;
                        return true;
                    }
                }
                if (this.handledIpHeaders(key, value)) {
                    return true;
                }
                this.handleTags(key, value);
                if (!this.baggageMapping.isEmpty() && null != (mappedKey = (String)this.baggageMapping.get(this.toLowerCase(key)))) {
                    XRayContextInterpreter.addBaggageItem(this, mappedKey, HttpCodec.decode(value));
                }
                return true;
            }
            catch (RuntimeException e) {
                this.invalidateContext();
                log.debug("Exception when extracting context", (Throwable)e);
                return false;
            }
        }

        static void handleXRayTraceHeader(ContextInterpreter interpreter, String value) {
            if (null != value) {
                int rootPart = value.indexOf(XRayHttpCodec.ROOT_PREFIX);
                if (rootPart < 0 || !value.regionMatches(rootPart + ROOT_PREAMBLE, XRayHttpCodec.TRACE_ID_PADDING, 0, XRayHttpCodec.TRACE_ID_PADDING.length())) {
                    return;
                }
                int startPart = 0;
                int length = value.length();
                while (startPart < length) {
                    String part;
                    int endPart = value.indexOf(59, startPart);
                    if (endPart < 0) {
                        endPart = length;
                    }
                    if ((part = value.substring(startPart, endPart).trim()).startsWith(XRayHttpCodec.ROOT_PREFIX)) {
                        if (interpreter.traceId == null || interpreter.traceId == DDTraceId.ZERO) {
                            interpreter.traceId = DD64bTraceId.fromHex((String)part.substring(ROOT_PREAMBLE + XRayHttpCodec.TRACE_ID_PADDING.length()));
                        }
                    } else if (part.startsWith(XRayHttpCodec.PARENT_PREFIX)) {
                        if (interpreter.spanId == 0L) {
                            interpreter.spanId = DDSpanId.fromHex((String)part.substring(XRayHttpCodec.PARENT_PREFIX.length()));
                        }
                    } else if (part.startsWith(XRayHttpCodec.SAMPLED_PREFIX)) {
                        if (interpreter.samplingPriority == -128) {
                            interpreter.samplingPriority = XRayContextInterpreter.convertSamplingPriority(part.charAt(XRayHttpCodec.SAMPLED_PREFIX.length()));
                        }
                    } else if (!part.startsWith(XRayHttpCodec.SELF_PREFIX)) {
                        if (part.startsWith(XRayHttpCodec.ORIGIN_PREFIX)) {
                            interpreter.origin = part.substring(XRayHttpCodec.ORIGIN_PREFIX.length());
                        } else if (part.startsWith(XRayHttpCodec.E2E_START_PREFIX)) {
                            interpreter.endToEndStartTime = XRayContextInterpreter.extractEndToEndStartTime(part.substring(XRayHttpCodec.E2E_START_PREFIX.length()));
                        } else {
                            int eqIndex = part.indexOf(61);
                            if (eqIndex > 0) {
                                XRayContextInterpreter.addBaggageItem(interpreter, part.substring(0, eqIndex), part.substring(eqIndex + 1));
                            }
                        }
                    }
                    startPart = endPart + 1;
                }
            }
        }

        private static long extractEndToEndStartTime(String value) {
            try {
                return TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value));
            }
            catch (RuntimeException e) {
                log.debug("Ignoring invalid end-to-end start time {}", (Object)value, (Object)e);
                return 0L;
            }
        }

        private static int convertSamplingPriority(char samplingPriority) {
            return '1' == samplingPriority ? 1 : 0;
        }

        private static void addBaggageItem(ContextInterpreter interpreter, String key, String value) {
            if (interpreter.baggage.isEmpty()) {
                interpreter.baggage = new TreeMap<String, String>();
            }
            interpreter.baggage.put(key, HttpCodec.decode(value));
        }
    }

    private static class Injector
    implements HttpCodec.Injector {
        private final Map<String, String> invertedBaggageMapping;

        public Injector(Map<String, String> invertedBaggageMapping) {
            this.invertedBaggageMapping = invertedBaggageMapping;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            long e2eStart = context.getEndToEndStartTime();
            StringBuilder buf = new StringBuilder().append(XRayHttpCodec.ROOT_PREFIX).append(String.format("%08x", e2eStart > 0L ? TimeUnit.NANOSECONDS.toSeconds(e2eStart) : TimeUnit.MILLISECONDS.toSeconds(context.getTrace().getTimeSource().getCurrentTimeMillis()))).append(XRayHttpCodec.TRACE_ID_PADDING).append(context.getTraceId().toHexStringPadded(16)).append(";Parent=").append(DDSpanId.toHexStringPadded((long)context.getSpanId()));
            if (context.lockSamplingPriority()) {
                buf.append(";Sampled=").append(this.convertSamplingPriority(context.getSamplingPriority()));
            }
            int maxCapacity = buf.length() + 256;
            CharSequence origin = context.getOrigin();
            if (origin != null) {
                this.additionalPart(buf, "_dd.origin", origin.toString(), maxCapacity);
            }
            if (e2eStart > 0L) {
                this.additionalPart(buf, XRayHttpCodec.E2E_START_KEY, Long.toString(TimeUnit.NANOSECONDS.toMillis(e2eStart)), maxCapacity);
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                String header = this.invertedBaggageMapping.getOrDefault(entry.getKey(), entry.getKey());
                if (this.isReserved(header)) continue;
                this.additionalPart(buf, header, HttpCodec.encode(entry.getValue()), maxCapacity);
            }
            setter.set(carrier, XRayHttpCodec.X_AMZN_TRACE_ID, buf.toString());
        }

        private boolean isReserved(String key) {
            return XRayHttpCodec.ROOT.equals(key) || XRayHttpCodec.PARENT.equals(key) || XRayHttpCodec.SAMPLED.equals(key) || XRayHttpCodec.SELF.equals(key);
        }

        private char convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? (char)'1' : '0';
        }

        private void additionalPart(StringBuilder buf, String key, String value, int maxCapacity) {
            if (buf.length() + key.length() + value.length() + 2 <= maxCapacity) {
                buf.append(';').append(key).append('=').append(value);
            }
        }
    }
}

