/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.Platform;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceStructureWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(TraceStructureWriter.class);
    private static final Pattern ARGS_DELIMITER = Pattern.compile(":", 16);
    private final PrintStream out;
    private final boolean debugLog;
    private final boolean includeResource;
    private final boolean includeService;

    public TraceStructureWriter() {
        this("", false);
    }

    public TraceStructureWriter(boolean debugLog) {
        this("", debugLog);
    }

    public TraceStructureWriter(String outputFile) {
        this(outputFile, false);
    }

    public TraceStructureWriter(String outputFile, boolean debugLog) {
        boolean argsDebugLog = debugLog;
        boolean argsIncludeResource = false;
        boolean argsIncludeService = false;
        if (null == outputFile) {
            outputFile = "";
        }
        if (!outputFile.isEmpty() && outputFile.charAt(0) == ':') {
            outputFile = outputFile.substring(1);
        }
        try {
            String[] args = TraceStructureWriter.parseArgs(outputFile);
            String fileName = args[0];
            this.out = fileName.isEmpty() ? System.err : new PrintStream(new FileOutputStream(fileName));
            block12: for (int i = 1; i < args.length; ++i) {
                switch (args[i].toLowerCase(Locale.ROOT)) {
                    case "includeresource": {
                        argsIncludeResource = true;
                        continue block12;
                    }
                    case "includeservice": {
                        argsIncludeService = true;
                        continue block12;
                    }
                    case "debuglog": {
                        argsDebugLog = true;
                        continue block12;
                    }
                    default: {
                        log.warn("Illegal TraceStructureWriter argument '" + args[i] + "'");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create trace structure writer from " + outputFile, e);
        }
        this.debugLog = argsDebugLog;
        this.includeResource = argsIncludeResource;
        this.includeService = argsIncludeService;
    }

    private static String[] parseArgs(String outputFile) {
        String[] args = ARGS_DELIMITER.split(outputFile);
        if (Platform.isWindows() && args.length > 1 && args[0].length() == 1 && (args[1].startsWith("\\") || args[1].startsWith("/"))) {
            String[] windowsArgs = new String[args.length - 1];
            windowsArgs[0] = args[0] + ":" + args[1];
            System.arraycopy(args, 2, windowsArgs, 1, args.length - 2);
            args = windowsArgs;
        }
        return args;
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            this.output("[]", null, 0L);
        } else {
            DDTraceId traceId = trace.get(0).getTraceId();
            long rootSpanId = trace.get(0).getSpanId();
            HashMap<Long, Node> nodesById = new HashMap<Long, Node>();
            for (DDSpan span : trace) {
                if (span.getLocalRootSpan() == span) {
                    rootSpanId = span.getSpanId();
                }
                nodesById.put(span.getSpanId(), new Node(span, this.includeService, this.includeResource));
            }
            for (DDSpan span : trace) {
                if (!traceId.equals(span.getTraceId())) {
                    String message = "Trace " + traceId + " has broken trace link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getTraceId();
                    this.out.println("ERROR: " + message);
                    if (this.debugLog) {
                        log.error(message);
                    }
                    return;
                }
                if (rootSpanId == span.getSpanId()) continue;
                Node parent = (Node)nodesById.get(span.getParentId());
                if (null == parent) {
                    String message = "Trace " + traceId + " has broken parent link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getParentId();
                    this.out.println("ERROR: " + message);
                    if (this.debugLog) {
                        log.error(message);
                    }
                    parent = (Node)nodesById.get(rootSpanId);
                }
                parent.addChild((Node)nodesById.get(span.getSpanId()));
            }
            this.output(String.valueOf(nodesById.get(rootSpanId)), traceId, rootSpanId);
        }
    }

    private void output(String trace, DDTraceId traceId, long rootSpanId) {
        this.out.println(trace);
        if (this.debugLog && log.isDebugEnabled()) {
            StringBuilder start = new StringBuilder();
            if (traceId != null) {
                start.append("t_id=").append(traceId);
            }
            if (rootSpanId != 0L) {
                if (start.length() > 0) {
                    start.append(", ");
                }
                start.append("s_id=").append(DDSpanId.toString((long)rootSpanId));
            }
            if (start.length() > 0) {
                start.append(" -> ");
            }
            log.debug("{}wrote {}", (Object)start, (Object)trace);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        this.out.flush();
        return true;
    }

    @Override
    public void close() {
        if (this.out != System.err) {
            this.out.close();
        }
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }

    private static final class Node {
        private final CharSequence operationName;
        private final CharSequence resourceName;
        private final CharSequence serviceName;
        private final List<Node> children = new ArrayList<Node>();

        private Node(DDSpan span, boolean includeService, boolean includeResource) {
            this.operationName = span.getOperationName();
            this.resourceName = includeResource ? span.getResourceName() : null;
            this.serviceName = includeService ? span.getServiceName() : null;
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (null != this.serviceName) {
                sb.append(this.serviceName).append(':');
            }
            sb.append(this.operationName);
            if (null != this.resourceName) {
                sb.append(':').append(this.resourceName);
            }
            for (Node node : this.children) {
                sb.append(node);
            }
            return sb.append(']').toString();
        }
    }
}

