/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation.ptags;

import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.ptags.PTagsCodec;
import ddtrot.dd.trace.core.propagation.ptags.PTagsFactory;
import ddtrot.dd.trace.core.propagation.ptags.TagElement;
import ddtrot.dd.trace.core.propagation.ptags.TagKey;
import ddtrot.dd.trace.core.propagation.ptags.TagValue;
import java.util.ArrayList;
import java.util.function.IntPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatadogPTagsCodec
extends PTagsCodec {
    private static final Logger log = LoggerFactory.getLogger(DatadogPTagsCodec.class);
    private static final String PROPAGATION_ERROR_EXTRACT_MAX_SIZE = "extract_max_size";
    private static final String PROPAGATION_ERROR_DECODING_ERROR = "decoding_error";
    private static final char TAGS_SEPARATOR = ',';
    private static final char TAG_KEY_SEPARATOR = '=';
    private static final int MIN_ALLOWED_CHAR = 32;
    private static final int MAX_ALLOWED_CHAR = 126;
    private final int xDatadogTagsLimit;

    DatadogPTagsCodec(int xDatadogTagsLimit) {
        this.xDatadogTagsLimit = xDatadogTagsLimit;
    }

    @Override
    PropagationTags fromHeaderValue(PTagsFactory tagsFactory, String value) {
        if (value == null) {
            return tagsFactory.empty();
        }
        if (value.length() > this.xDatadogTagsLimit) {
            return tagsFactory.createInvalid(PROPAGATION_ERROR_EXTRACT_MAX_SIZE);
        }
        ArrayList<TagValue> tagPairs = null;
        int len = value.length();
        int tagPos = 0;
        TagValue decisionMakerTagValue = null;
        TagValue traceIdTagValue = null;
        while (tagPos < len) {
            int tagKeyEndsAt = DatadogPTagsCodec.validateCharsUntilSeparatorOrEnd(value, tagPos, '=', DatadogPTagsCodec::isAllowedKeyChar);
            if (tagKeyEndsAt < 0 || tagKeyEndsAt == len) {
                log.warn("Invalid datadog tags header value: '{}' at {}", (Object)value, (Object)tagPos);
                return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
            }
            int tagValuePos = tagKeyEndsAt + 1;
            int tagValueEndsAt = DatadogPTagsCodec.validateCharsUntilSeparatorOrEnd(value, tagValuePos, ',', DatadogPTagsCodec::isAllowedValueChar);
            if (tagValueEndsAt < 0) {
                log.warn("Invalid datadog tags header value: '{}' at {}", (Object)value, (Object)tagKeyEndsAt);
                return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
            }
            TagKey tagKey = TagKey.from(TagElement.Encoding.DATADOG, value, tagPos, tagKeyEndsAt);
            TagValue tagValue = TagValue.from(TagElement.Encoding.DATADOG, value, tagValuePos, tagValueEndsAt);
            if (tagKey != null && !tagKey.equals(UPSTREAM_SERVICES_DEPRECATED_TAG)) {
                if (!DatadogPTagsCodec.validateTagValue(tagKey, tagValue)) {
                    log.warn("Invalid datadog tags header value: '{}' invalid tag value at {}", (Object)value, (Object)tagValuePos);
                    if (tagKey.equals(TRACE_ID_TAG)) {
                        return tagsFactory.createInvalid("malformed_tid " + tagValue);
                    }
                    return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
                }
                if (tagKey.equals(DECISION_MAKER_TAG)) {
                    decisionMakerTagValue = tagValue;
                } else if (tagKey.equals(TRACE_ID_TAG)) {
                    traceIdTagValue = tagValue;
                } else {
                    if (tagPairs == null) {
                        tagPairs = new ArrayList<TagValue>(6);
                    }
                    tagPairs.add((TagValue)((Object)tagKey));
                    tagPairs.add(tagValue);
                }
            }
            tagPos = tagValueEndsAt + 1;
        }
        return tagsFactory.createValid(tagPairs, decisionMakerTagValue, traceIdTagValue);
    }

    @Override
    protected int estimateHeaderSize(PTagsFactory.PTags pTags) {
        return pTags.getXDatadogTagsSize();
    }

    @Override
    protected int appendPrefix(StringBuilder sb, PTagsFactory.PTags ptags) {
        return ptags.getXDatadogTagsSize();
    }

    @Override
    protected int appendTag(StringBuilder sb, TagElement key, TagElement value, int size) {
        if (size <= this.xDatadogTagsLimit) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key.forType(TagElement.Encoding.DATADOG));
            sb.append('=');
            sb.append(value.forType(TagElement.Encoding.DATADOG));
        }
        return size;
    }

    @Override
    protected int appendSuffix(StringBuilder sb, PTagsFactory.PTags ptags, int size) {
        return size;
    }

    @Override
    protected boolean isTooLarge(StringBuilder sb, int size) {
        return size > this.xDatadogTagsLimit;
    }

    @Override
    protected boolean isEmpty(StringBuilder sb, int size) {
        return sb.length() == 0;
    }

    private static int validateCharsUntilSeparatorOrEnd(String s, int start, char separator, IntPredicate isValid) {
        int end = s.length();
        if (start >= end) {
            return -1;
        }
        int pos = start;
        char c = s.charAt(pos);
        do {
            if (!isValid.test(c) || c == separator) {
                return -1;
            }
            if (++pos >= end) continue;
            c = s.charAt(pos);
            if (pos < end - 1 && c == separator) break;
        } while (pos < end);
        return pos;
    }

    private static boolean isAllowedKeyChar(int c) {
        return c > 32 && c <= 126 && c != 44;
    }

    private static boolean isAllowedValueChar(int c) {
        return c >= 32 && c <= 126;
    }
}

