/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import datadog.trace.api.Config;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.common.sampling.AllSampler;
import ddtrot.dd.trace.common.sampling.ForcePrioritySampler;
import ddtrot.dd.trace.common.sampling.RateByServiceTraceSampler;
import ddtrot.dd.trace.common.sampling.RuleBasedTraceSampler;
import ddtrot.dd.trace.common.sampling.TraceSamplingRules;
import ddtrot.dd.trace.core.CoreSpan;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Sampler {
    public <T extends CoreSpan<T>> boolean sample(T var1);

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Sampler forConfig(Config config, TraceConfig traceConfig) {
            Sampler sampler;
            if (config != null) {
                Double traceSampleRate;
                boolean jsonTraceSamplingRulesDefined;
                Map<String, String> serviceRules = config.getTraceSamplingServiceRules();
                Map<String, String> operationRules = config.getTraceSamplingOperationRules();
                String traceSamplingRulesJson = config.getTraceSamplingRules();
                TraceSamplingRules traceSamplingRules = null;
                if (traceSamplingRulesJson != null) {
                    traceSamplingRules = TraceSamplingRules.deserialize(traceSamplingRulesJson);
                }
                boolean serviceRulesDefined = serviceRules != null && !serviceRules.isEmpty();
                boolean operationRulesDefined = operationRules != null && !operationRules.isEmpty();
                boolean bl = jsonTraceSamplingRulesDefined = traceSamplingRules != null && !traceSamplingRules.isEmpty();
                if ((serviceRulesDefined || operationRulesDefined) && jsonTraceSamplingRulesDefined) {
                    log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", new Object[]{"trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules"});
                }
                Double d = traceSampleRate = null != traceConfig ? traceConfig.getTraceSampleRate() : config.getTraceSampleRate();
                if (serviceRulesDefined || operationRulesDefined || jsonTraceSamplingRulesDefined || traceSampleRate != null) {
                    try {
                        sampler = RuleBasedTraceSampler.build(serviceRules, operationRules, traceSamplingRules, traceSampleRate, config.getTraceRateLimit());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid sampler configuration. Using AllSampler", (Throwable)e);
                        sampler = new AllSampler();
                    }
                } else if (config.isPrioritySamplingEnabled()) {
                    if ("keep".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_KEEP.");
                        sampler = new ForcePrioritySampler(1, 0);
                    } else if ("drop".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_DROP.");
                        sampler = new ForcePrioritySampler(0, 0);
                    } else {
                        sampler = new RateByServiceTraceSampler();
                    }
                } else {
                    sampler = new AllSampler();
                }
            } else {
                sampler = new AllSampler();
            }
            return sampler;
        }

        public static Sampler forConfig(Properties config) {
            return Builder.forConfig(Config.get(config), null);
        }

        private Builder() {
        }
    }
}

