/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DynamicConfig;
import ddtrot.com.squareup.moshi.Json;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.remoteconfig.ConfigurationChangesListener;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.dd.remoteconfig.Product;
import ddtrot.dd.remoteconfig.state.ParsedConfigKey;
import ddtrot.dd.remoteconfig.state.ProductListener;
import ddtrot.dd.trace.logging.GlobalLogLevelSwitcher;
import ddtrot.dd.trace.logging.LogLevel;
import ddtrot.okio.Okio;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracingConfigPoller {
    private static final Logger log = LoggerFactory.getLogger(TracingConfigPoller.class);
    private final DynamicConfig dynamicConfig;
    private boolean startupLogsEnabled;
    private Runnable stopPolling;

    public TracingConfigPoller(DynamicConfig dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void start(Config config, SharedCommunicationObjects sco) {
        this.startupLogsEnabled = config.isStartupLogsEnabled();
        this.stopPolling = new Updater().register(config, sco);
    }

    public void stop() {
        if (null != this.stopPolling) {
            this.stopPolling.run();
        }
    }

    void applyConfigOverrides(LibConfig libConfig) {
        DynamicConfig.Builder builder = this.dynamicConfig.initial();
        this.maybeOverride(builder::setDebugEnabled, libConfig.debugEnabled);
        if (libConfig.debugEnabled != null) {
            if (Boolean.TRUE.equals(libConfig.debugEnabled)) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.DEBUG);
            } else if (this.startupLogsEnabled) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.INFO);
            } else {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.WARN);
            }
        }
        this.maybeOverride(builder::setRuntimeMetricsEnabled, libConfig.runtimeMetricsEnabled);
        this.maybeOverride(builder::setLogsInjectionEnabled, libConfig.logsInjectionEnabled);
        this.maybeOverride(builder::setDataStreamsEnabled, libConfig.dataStreamsEnabled);
        this.maybeOverride(builder::setServiceMapping, libConfig.serviceMapping);
        this.maybeOverride(builder::setHeaderTags, libConfig.headerTags);
        this.maybeOverride(builder::setTraceSampleRate, libConfig.traceSampleRate);
        builder.apply();
    }

    void removeConfigOverrides() {
        this.dynamicConfig.resetTraceConfig();
        GlobalLogLevelSwitcher.get().restore();
    }

    private <T> void maybeOverride(Consumer<T> setter, T override) {
        if (null != override) {
            setter.accept(override);
        }
    }

    static final class HeaderTagEntry
    implements Map.Entry<String, String> {
        @Json(name="header")
        public String header;
        @Json(name="tag_name")
        public String tagName;

        HeaderTagEntry() {
        }

        @Override
        public String getKey() {
            return this.header;
        }

        @Override
        public String getValue() {
            return this.tagName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class ServiceMappingEntry
    implements Map.Entry<String, String> {
        @Json(name="from_key")
        public String fromKey;
        @Json(name="to_name")
        public String toName;

        ServiceMappingEntry() {
        }

        @Override
        public String getKey() {
            return this.fromKey;
        }

        @Override
        public String getValue() {
            return this.toName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class LibConfig {
        @Json(name="tracing_debug")
        public Boolean debugEnabled;
        @Json(name="runtime_metrics_enabled")
        public Boolean runtimeMetricsEnabled;
        @Json(name="log_injection_enabled")
        public Boolean logsInjectionEnabled;
        @Json(name="data_streams_enabled")
        public Boolean dataStreamsEnabled;
        @Json(name="tracing_service_mapping")
        public List<ServiceMappingEntry> serviceMapping;
        @Json(name="tracing_header_tags")
        public List<HeaderTagEntry> headerTags;
        @Json(name="tracing_sampling_rate")
        public Double traceSampleRate;

        LibConfig() {
        }
    }

    static final class ConfigOverrides {
        @Json(name="lib_config")
        public LibConfig libConfig;

        ConfigOverrides() {
        }
    }

    final class Updater
    implements ProductListener {
        private final Moshi MOSHI = new Moshi.Builder().build();
        private final JsonAdapter<ConfigOverrides> CONFIG_OVERRIDES_ADAPTER = this.MOSHI.adapter(ConfigOverrides.class);
        private boolean receivedOverrides = false;

        Updater() {
        }

        public Runnable register(Config config, SharedCommunicationObjects sco) {
            ConfigurationPoller poller = sco.configurationPoller(config);
            if (null != poller) {
                poller.addListener(Product.APM_TRACING, (ProductListener)this);
                return () -> ((ConfigurationPoller)poller).stop();
            }
            return null;
        }

        public void accept(ParsedConfigKey configKey, byte[] content, ConfigurationChangesListener.PollingRateHinter hinter) throws IOException {
            ConfigOverrides overrides = this.CONFIG_OVERRIDES_ADAPTER.fromJson(Okio.buffer(Okio.source(new ByteArrayInputStream(content))));
            if (null != overrides && null != overrides.libConfig) {
                this.receivedOverrides = true;
                TracingConfigPoller.this.applyConfigOverrides(overrides.libConfig);
                if (log.isDebugEnabled()) {
                    log.debug("Applied APM_TRACING overrides: {}", (Object)this.CONFIG_OVERRIDES_ADAPTER.toJson(overrides));
                }
            } else {
                log.debug("No APM_TRACING overrides");
            }
        }

        public void remove(ParsedConfigKey configKey, ConfigurationChangesListener.PollingRateHinter hinter) {
        }

        public void commit(ConfigurationChangesListener.PollingRateHinter hinter) {
            if (!this.receivedOverrides) {
                TracingConfigPoller.this.removeConfigOverrides();
                log.debug("Removed APM_TRACING overrides");
            } else {
                this.receivedOverrides = false;
            }
        }
    }
}

