/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DDTraceId;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public abstract class IdGenerationStrategy {
    private IdGenerationStrategy() {
    }

    public static IdGenerationStrategy fromName(String name) {
        switch (name.toUpperCase()) {
            case "RANDOM": {
                return new Random();
            }
            case "SEQUENTIAL": {
                return new Sequential();
            }
            case "SECURE_RANDOM": {
                return new SRandom();
            }
        }
        return null;
    }

    public abstract DDTraceId generateTraceId();

    public abstract long generateSpanId();

    static final class SRandom
    extends IdGenerationStrategy {
        private final SecureRandom secureRandom;

        SRandom() {
            this(SecureRandom::getInstanceStrong);
        }

        SRandom(ThrowingSupplier<SecureRandom> supplier) {
            try {
                this.secureRandom = supplier.get();
            }
            catch (Throwable e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        private long getNonZeroPositiveLong() {
            long value = this.secureRandom.nextLong() & Long.MAX_VALUE;
            while (value == 0L) {
                value = this.secureRandom.nextLong() & Long.MAX_VALUE;
            }
            return value;
        }

        @Override
        public DDTraceId generateTraceId() {
            return DDTraceId.from(this.getNonZeroPositiveLong());
        }

        @Override
        public long generateSpanId() {
            return this.getNonZeroPositiveLong();
        }
    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }

    static final class Sequential
    extends IdGenerationStrategy {
        private final AtomicLong id = new AtomicLong(0L);

        Sequential() {
        }

        @Override
        public DDTraceId generateTraceId() {
            return DDTraceId.from(this.id.incrementAndGet());
        }

        @Override
        public long generateSpanId() {
            return this.id.incrementAndGet();
        }
    }

    static final class Random
    extends IdGenerationStrategy {
        Random() {
        }

        @Override
        public DDTraceId generateTraceId() {
            return DDTraceId.from(ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE));
        }

        @Override
        public long generateSpanId() {
            return ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE);
        }
    }
}

