/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.metrics;

import ddtrot.dd.trace.common.metrics.AggregateMetric;
import ddtrot.dd.trace.common.metrics.Batch;
import ddtrot.dd.trace.common.metrics.InboxItem;
import ddtrot.dd.trace.common.metrics.MetricKey;
import ddtrot.dd.trace.common.metrics.MetricWriter;
import ddtrot.dd.trace.common.metrics.SignalItem;
import ddtrot.dd.trace.core.util.LRUCache;
import ddtrot.org.jctools.maps.NonBlockingHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Aggregator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Aggregator.class);
    private final Queue<Batch> batchPool;
    private final BlockingQueue<InboxItem> inbox;
    private final LRUCache<MetricKey, AggregateMetric> aggregates;
    private final NonBlockingHashMap<MetricKey, Batch> pending;
    private final Set<MetricKey> commonKeys;
    private final MetricWriter writer;
    private final long reportingIntervalNanos;
    private boolean dirty;

    Aggregator(MetricWriter writer, Queue<Batch> batchPool, BlockingQueue<InboxItem> inbox, NonBlockingHashMap<MetricKey, Batch> pending, Set<MetricKey> commonKeys, int maxAggregates, long reportingInterval, TimeUnit reportingIntervalTimeUnit) {
        this.writer = writer;
        this.batchPool = batchPool;
        this.inbox = inbox;
        this.commonKeys = commonKeys;
        this.aggregates = new LRUCache<MetricKey, AggregateMetric>(new CommonKeyCleaner(commonKeys), maxAggregates * 4 / 3, 0.75f, maxAggregates);
        this.pending = pending;
        this.reportingIntervalNanos = reportingIntervalTimeUnit.toNanos(reportingInterval);
    }

    public void clearAggregates() {
        this.aggregates.clear();
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        while (!currentThread.isInterrupted()) {
            try {
                InboxItem item = this.inbox.take();
                if (item instanceof SignalItem.StopSignal) {
                    this.stop((SignalItem.StopSignal)item);
                    break;
                }
                if (item instanceof SignalItem.ReportSignal) {
                    this.report(this.wallClockTime(), (SignalItem.ReportSignal)item);
                    continue;
                }
                if (!(item instanceof Batch)) continue;
                Batch batch = (Batch)item;
                MetricKey key = batch.getKey();
                this.pending.remove(key, batch);
                AggregateMetric aggregate = (AggregateMetric)this.aggregates.get(key);
                if (null == aggregate) {
                    aggregate = new AggregateMetric();
                    this.aggregates.put(key, aggregate);
                }
                batch.contributeTo(aggregate);
                this.dirty = true;
                this.batchPool.offer(batch);
            }
            catch (InterruptedException e) {
                currentThread.interrupt();
            }
            catch (Throwable error) {
                log.debug("error aggregating metrics", error);
            }
        }
        log.debug("metrics aggregator exited");
    }

    private void stop(SignalItem.StopSignal stopSignal) {
        this.report(this.wallClockTime(), stopSignal);
        for (InboxItem item : this.inbox) {
            if (!(item instanceof SignalItem)) continue;
            ((SignalItem)item).ignore();
        }
        stopSignal.complete();
    }

    private void report(long when, SignalItem signal) {
        boolean skipped = true;
        if (this.dirty) {
            try {
                this.expungeStaleAggregates();
                if (!this.aggregates.isEmpty()) {
                    skipped = false;
                    this.writer.startBucket(this.aggregates.size(), when, this.reportingIntervalNanos);
                    for (Map.Entry aggregate : this.aggregates.entrySet()) {
                        this.writer.add((MetricKey)aggregate.getKey(), (AggregateMetric)aggregate.getValue());
                        ((AggregateMetric)aggregate.getValue()).clear();
                    }
                    this.writer.finishBucket();
                }
            }
            catch (Throwable error) {
                this.writer.reset();
                log.debug("Error publishing metrics. Dropping payload", error);
            }
            this.dirty = false;
        }
        signal.complete();
        if (skipped) {
            log.debug("skipped metrics reporting because no points have changed");
        }
    }

    private void expungeStaleAggregates() {
        Iterator it = this.aggregates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            AggregateMetric metric = (AggregateMetric)pair.getValue();
            if (metric.getHitCount() != 0) continue;
            it.remove();
            this.commonKeys.remove(pair.getKey());
        }
    }

    private long wallClockTime() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    private static final class CommonKeyCleaner
    implements LRUCache.ExpiryListener<MetricKey, AggregateMetric> {
        private final Set<MetricKey> commonKeys;

        private CommonKeyCleaner(Set<MetricKey> commonKeys) {
            this.commonKeys = commonKeys;
        }

        @Override
        public void accept(Map.Entry<MetricKey, AggregateMetric> expired) {
            this.commonKeys.remove(expired.getKey());
        }
    }
}

