/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.communication.serialization.ByteBufferConsumer;
import ddtrot.dd.communication.serialization.FlushingBuffer;
import ddtrot.dd.communication.serialization.WritableFormatter;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.common.writer.RemoteMapperDiscovery;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.org.jctools.counters.CountersFactory;
import ddtrot.org.jctools.counters.FixedSizeStripedLongCounter;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadDispatcher
implements ByteBufferConsumer {
    private static final Logger log = LoggerFactory.getLogger(PayloadDispatcher.class);
    private final RemoteApi api;
    private final RemoteMapperDiscovery mapperDiscovery;
    private final HealthMetrics healthMetrics;
    private final Monitoring monitoring;
    private Recording batchTimer;
    private RemoteMapper mapper;
    private WritableFormatter packer;
    private final FixedSizeStripedLongCounter droppedSpanCount = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter droppedTraceCount = CountersFactory.createFixedSizeStripedCounter(8);

    public PayloadDispatcher(RemoteMapperDiscovery mapperDiscovery, RemoteApi api, HealthMetrics healthMetrics, Monitoring monitoring) {
        this.mapperDiscovery = mapperDiscovery;
        this.api = api;
        this.healthMetrics = healthMetrics;
        this.monitoring = monitoring;
    }

    void flush() {
        if (null != this.packer) {
            this.packer.flush();
        }
    }

    public void onDroppedTrace(int spanCount) {
        this.droppedSpanCount.inc(spanCount);
        this.droppedTraceCount.inc();
    }

    void addTrace(List<? extends CoreSpan<?>> trace) {
        this.selectMapper();
        if (null == this.mapper || !this.packer.format(trace, this.mapper)) {
            this.healthMetrics.onFailedPublish(trace.get(0).samplingPriority());
        }
    }

    private void selectMapper() {
        if (null == this.mapper) {
            if (this.mapperDiscovery.getMapper() == null) {
                this.mapperDiscovery.discover();
            }
            this.mapper = this.mapperDiscovery.getMapper();
            if (null != this.mapper && null == this.packer) {
                this.batchTimer = this.monitoring.newTimer("tracer.trace.buffer.fill.time", "endpoint:" + this.mapper.endpoint());
                this.packer = new MsgPackWriter(new FlushingBuffer(this.mapper.messageBufferSize(), this));
                this.batchTimer.start();
            }
        }
    }

    Payload newPayload(int messageCount, ByteBuffer buffer) {
        return this.mapper.newPayload().withBody(messageCount, buffer).withDroppedSpans(this.droppedSpanCount.getAndReset()).withDroppedTraces(this.droppedTraceCount.getAndReset());
    }

    @Override
    public void accept(int messageCount, ByteBuffer buffer) {
        if (messageCount > 0) {
            this.batchTimer.reset();
            Payload payload = this.newPayload(messageCount, buffer);
            int sizeInBytes = payload.sizeInBytes();
            this.healthMetrics.onSerialize(sizeInBytes);
            RemoteApi.Response response = this.api.sendSerializedTraces(payload);
            this.mapper.reset();
            if (response.success()) {
                if (log.isDebugEnabled()) {
                    log.debug("Successfully sent {} traces to the API", (Object)messageCount);
                }
                this.healthMetrics.onSend(messageCount, sizeInBytes, response);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to send {} traces of size {} bytes to the API", (Object)messageCount, (Object)sizeInBytes);
                }
                this.healthMetrics.onFailedSend(messageCount, sizeInBytes, response);
            }
        }
    }
}

