/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.DatadogTags;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import ddtrot.dd.trace.core.propagation.XRayHttpCodec;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatadogHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(DatadogHttpCodec.class);
    static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    static final String TRACE_ID_KEY = "x-datadog-trace-id";
    static final String SPAN_ID_KEY = "x-datadog-parent-id";
    static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";
    static final String ORIGIN_KEY = "x-datadog-origin";
    private static final String E2E_START_KEY = "ot-baggage-t0";
    static final String DATADOG_TAGS_KEY = "x-datadog-tags";
    public static final HttpCodec.Injector INJECTOR = new Injector();

    private DatadogHttpCodec() {
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping) {
        return DatadogHttpCodec.newExtractor(tagMapping, Config.get());
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping, final Config config) {
        return new TagContextExtractor(tagMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping) {
                return new DatadogContextInterpreter(mapping, config);
            }
        });
    }

    private static class DatadogContextInterpreter
    extends ContextInterpreter {
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int ORIGIN = 2;
        private static final int SAMPLING_PRIORITY = 3;
        private static final int TAGS = 4;
        private static final int OT_BAGGAGE = 5;
        private static final int E2E_START = 6;
        private static final int DD_TAGS = 7;
        private static final int IGNORE = -1;
        private final boolean isAwsPropagationEnabled;
        private final DatadogTags.Factory datadogTagsFactory;

        private DatadogContextInterpreter(Map<String, String> taggedHeaders, Config config) {
            super(taggedHeaders, config);
            this.isAwsPropagationEnabled = config.isAwsPropagationEnabled();
            this.datadogTagsFactory = DatadogTags.factory(config);
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            String lowerCaseKey = null;
            int classification = -1;
            char first = Character.toLowerCase(key.charAt(0));
            switch (first) {
                case 'x': {
                    if (DatadogHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        classification = 0;
                        break;
                    }
                    if (DatadogHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        classification = 1;
                        break;
                    }
                    if (DatadogHttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        classification = 3;
                        break;
                    }
                    if (DatadogHttpCodec.ORIGIN_KEY.equalsIgnoreCase(key)) {
                        classification = 2;
                        break;
                    }
                    if (this.isAwsPropagationEnabled && "X-Amzn-Trace-Id".equalsIgnoreCase(key)) {
                        XRayHttpCodec.XRayContextInterpreter.handleXRayTraceHeader(this, value);
                        return true;
                    }
                    if (this.handledXForwarding(key, value)) {
                        return true;
                    }
                    if (!DatadogHttpCodec.DATADOG_TAGS_KEY.equalsIgnoreCase(key)) break;
                    classification = 7;
                    break;
                }
                case 'f': {
                    if (!this.handledForwarding(key, value)) break;
                    return true;
                }
                case 'u': {
                    if (!this.handledUserAgent(key, value)) break;
                    return true;
                }
                case 'o': {
                    lowerCaseKey = this.toLowerCase(key);
                    if (DatadogHttpCodec.E2E_START_KEY.equals(lowerCaseKey)) {
                        classification = 6;
                        break;
                    }
                    if (!lowerCaseKey.startsWith(DatadogHttpCodec.OT_BAGGAGE_PREFIX)) break;
                    classification = 5;
                    break;
                }
            }
            if (this.handledIpHeaders(key, value)) {
                return true;
            }
            if (!this.taggedHeaders.isEmpty() && classification == -1 && this.taggedHeaders.containsKey(lowerCaseKey = this.toLowerCase(key))) {
                classification = 4;
            }
            if (classification != -1) {
                try {
                    if (null != value) {
                        switch (classification) {
                            case 0: {
                                this.traceId = DDTraceId.from(HttpCodec.firstHeaderValue(value));
                                break;
                            }
                            case 1: {
                                this.spanId = DDSpanId.from(HttpCodec.firstHeaderValue(value));
                                break;
                            }
                            case 2: {
                                this.origin = HttpCodec.firstHeaderValue(value);
                                break;
                            }
                            case 3: {
                                this.samplingPriority = Integer.parseInt(HttpCodec.firstHeaderValue(value));
                                break;
                            }
                            case 6: {
                                this.endToEndStartTime = this.extractEndToEndStartTime(HttpCodec.firstHeaderValue(value));
                                break;
                            }
                            case 7: {
                                this.datadogTags = this.datadogTagsFactory.fromHeaderValue(value);
                                break;
                            }
                            case 4: {
                                String mappedKey = (String)this.taggedHeaders.get(lowerCaseKey);
                                if (null == mappedKey) break;
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(mappedKey, HttpCodec.decode(value));
                                break;
                            }
                            case 5: {
                                if (this.baggage.isEmpty()) {
                                    this.baggage = new TreeMap();
                                }
                                this.baggage.put(lowerCaseKey.substring(DatadogHttpCodec.OT_BAGGAGE_PREFIX.length()), HttpCodec.decode(value));
                                break;
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        private long extractEndToEndStartTime(String value) {
            try {
                return TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value));
            }
            catch (RuntimeException e) {
                log.debug("Ignoring invalid end-to-end start time {}", (Object)value, (Object)e);
                return 0L;
            }
        }
    }

    private static class Injector
    implements HttpCodec.Injector {
        private Injector() {
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            long e2eStart;
            CharSequence origin;
            setter.set(carrier, DatadogHttpCodec.TRACE_ID_KEY, context.getTraceId().toString());
            setter.set(carrier, DatadogHttpCodec.SPAN_ID_KEY, DDSpanId.toString(context.getSpanId()));
            if (context.lockSamplingPriority()) {
                setter.set(carrier, DatadogHttpCodec.SAMPLING_PRIORITY_KEY, String.valueOf(context.getSamplingPriority()));
            }
            if ((origin = context.getOrigin()) != null) {
                setter.set(carrier, DatadogHttpCodec.ORIGIN_KEY, origin.toString());
            }
            if ((e2eStart = context.getEndToEndStartTime()) > 0L) {
                setter.set(carrier, DatadogHttpCodec.E2E_START_KEY, Long.toString(TimeUnit.NANOSECONDS.toMillis(e2eStart)));
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                setter.set(carrier, DatadogHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            String datadogTags = context.getDatadogTags().headerValue();
            if (datadogTags != null) {
                setter.set(carrier, DatadogHttpCodec.DATADOG_TAGS_KEY, datadogTags);
            }
        }
    }
}

