/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import ddtrot.dd.trace.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceUtils {
    private static final int MAX_TYPE_LEN = 100;
    private static final int MAX_SERVICE_LEN = 100;
    private static final int MAX_OP_NAME_LEN = 100;
    private static final int MAX_ENV_LEN = 200;
    static final String DEFAULT_SERVICE_NAME = "unnamed-service";
    static final String DEFAULT_OPERATION_NAME = "unnamed_operation";
    private static final Logger log = LoggerFactory.getLogger(TraceUtils.class);

    public static String normalizeServiceName(String service) {
        if (service == null || service.isEmpty()) {
            log.debug("Fixing malformed trace. Service  is empty (reason:service_empty), setting span.service={}.", (Object)service);
            return DEFAULT_SERVICE_NAME;
        }
        String svc = service;
        if (svc.length() > 100) {
            log.debug("Fixing malformed trace. Service is too long (reason:service_truncate), truncating span.service to length={}.", (Object)100);
            svc = Strings.truncate(svc, 100);
        }
        return TraceUtils.normalizeTag(svc);
    }

    public static CharSequence normalizeOperationName(CharSequence opName) {
        if (opName == null || opName.length() == 0) {
            return DEFAULT_OPERATION_NAME;
        }
        CharSequence name = opName;
        if (name.length() > 100) {
            log.debug("Fixing malformed trace. Name is too long (reason:span_name_truncate), truncating span.name to length={}.", (Object)100);
            name = Strings.truncate(name, 100);
        }
        if ((name = TraceUtils.normalizeSpanName(name)).length() == 0) {
            name = DEFAULT_OPERATION_NAME;
        }
        return name;
    }

    public static String normalizeSpanType(String spanType) {
        if (spanType != null && spanType.length() > 100) {
            log.debug("Fixing malformed trace. Type is too long (reason:type_truncate), truncating span.type to length={}", (Object)100);
            return Strings.truncate(spanType, 100);
        }
        return spanType;
    }

    public static String normalizeEnv(String env) {
        if (env == null || env.length() == 0) {
            return "";
        }
        String e = Strings.truncate(env, 200);
        return TraceUtils.normalizeTag(e);
    }

    public static boolean isValidStatusCode(int httpStatusCode) {
        return httpStatusCode >= 100 && httpStatusCode < 600;
    }

    public static String normalizeTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(tag.length());
        boolean isJumping = false;
        for (int i = 0; i < tag.length(); ++i) {
            char ch = tag.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch == ':') {
                isJumping = false;
                builder.append(ch);
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                isJumping = false;
                ch = (char)(ch + 32);
                builder.append(ch);
                continue;
            }
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            }
            if (Character.isLetter(ch)) {
                isJumping = false;
                builder.append(ch);
                continue;
            }
            if (builder.length() == 0) continue;
            if (Character.isDigit(ch) || ch == '.' || ch == '/' || ch == '-') {
                isJumping = false;
                builder.append(ch);
                continue;
            }
            if (isJumping) continue;
            builder.append('_');
            isJumping = true;
        }
        if (isJumping) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static CharSequence normalizeSpanName(CharSequence name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder builder = new StringBuilder(name.length());
        int i = 0;
        int previousCh = 0;
        for (i = 0; i < name.length() && !TraceUtils.isAlpha(name.charAt(i)); ++i) {
        }
        if (i == name.length()) {
            return "";
        }
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (TraceUtils.isAlphaNum(ch)) {
                builder.append(ch);
                previousCh = ch;
            } else if (ch == '.') {
                if (previousCh == 95) {
                    builder.setLength(builder.length() - 1);
                }
                builder.append(ch);
                previousCh = ch;
            } else if (previousCh != 46 && previousCh != 95) {
                builder.append('_');
                previousCh = 95;
            }
            ++i;
        }
        if (previousCh == 95) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAlphaNum(char ch) {
        return TraceUtils.isAlpha(ch) || ch >= '0' && ch <= '9';
    }
}

