/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.http;

import ddtrot.okhttp3.Response;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpRetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(HttpRetryPolicy.class);
    private static final int NO_RESPONSE_RECEIVED = -1;
    private static final int TOO_MANY_REQUESTS_HTTP_CODE = 429;
    private static final String X_RATELIMIT_RESET_HTTP_HEADER = "x-ratelimit-reset";
    private static final int RATE_LIMIT_RESET_TIME_UNDEFINED = -1;
    private static final int MAX_ALLOWED_WAIT_TIME_SECONDS = 10;
    private static final int RATE_LIMIT_DELAY_RANDOM_COMPONENT_MAX_MILLIS = 401;
    private int retriesLeft;
    private long delay;
    private final double delayFactor;

    private HttpRetryPolicy(int retriesLeft, long delay, double delayFactor) {
        this.retriesLeft = retriesLeft;
        this.delay = delay;
        this.delayFactor = delayFactor;
    }

    public boolean shouldRetry(@Nullable Response response) {
        int responseCode;
        if (this.retriesLeft == 0) {
            return false;
        }
        int n = responseCode = response != null ? response.code() : -1;
        if (responseCode == 429) {
            long waitTimeSeconds = this.getRateLimitResetTime(response);
            if (waitTimeSeconds == -1L) {
                --this.retriesLeft;
                return true;
            }
            if (waitTimeSeconds > 10L) {
                return false;
            }
            this.retriesLeft = 0;
            this.delay = TimeUnit.SECONDS.toMillis(waitTimeSeconds) + (long)ThreadLocalRandom.current().nextInt(401);
            return true;
        }
        if (responseCode >= 500 || responseCode == -1) {
            --this.retriesLeft;
            return true;
        }
        return false;
    }

    private long getRateLimitResetTime(Response response) {
        String rateLimitHeader = response.header(X_RATELIMIT_RESET_HTTP_HEADER);
        if (rateLimitHeader == null) {
            return -1L;
        }
        try {
            return Long.parseLong(rateLimitHeader);
        }
        catch (NumberFormatException e) {
            log.error("Could not parse x-ratelimit-reset header contents: " + rateLimitHeader, (Throwable)e);
            return -1L;
        }
    }

    public long backoff() {
        long currentDelay = this.delay;
        this.delay = (long)((double)this.delay * this.delayFactor);
        return currentDelay;
    }

    public static final class Factory {
        private final int maxRetries;
        private final long initialDelay;
        private final double delayFactor;

        public Factory(int maxRetries, int initialDelay, double delayFactor) {
            this.maxRetries = maxRetries;
            this.initialDelay = initialDelay;
            this.delayFactor = delayFactor;
        }

        public HttpRetryPolicy create() {
            return new HttpRetryPolicy(this.maxRetries, this.initialDelay, this.delayFactor);
        }
    }
}

