/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.writer.ddintake;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.api.civisibility.coverage.TestReport;
import ddtrot.dd.trace.api.civisibility.coverage.TestReportFileEntry;
import ddtrot.dd.trace.api.civisibility.coverage.TestReportHolder;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.okhttp3.MultipartBody;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CiTestCovMapperV2
implements RemoteMapper {
    private static final byte[] VERSION = "version".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COVERAGES = "coverages".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_SESSION_ID = "test_session_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_SUITE_ID = "test_suite_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] FILES = "files".getBytes(StandardCharsets.UTF_8);
    private static final byte[] FILENAME = "filename".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SEGMENTS = "segments".getBytes(StandardCharsets.UTF_8);
    private final int size;
    private final GrowableBuffer headerBuffer;
    private final MsgPackWriter headerWriter;
    private int eventCount = 0;

    public CiTestCovMapperV2() {
        this(0x500000);
    }

    private CiTestCovMapperV2(int size) {
        this.size = size;
        this.headerBuffer = new GrowableBuffer(16);
        this.headerWriter = new MsgPackWriter(this.headerBuffer);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        List testReports = trace.stream().map(CiTestCovMapperV2::getTestReport).filter(Objects::nonNull).filter(TestReport::isNotEmpty).collect(Collectors.toList());
        for (TestReport testReport : testReports) {
            Long testSessionId = testReport.getTestSessionId();
            Long testSuiteId = testReport.getTestSuiteId();
            int fieldCount = 2 + (testSessionId != null ? 1 : 0) + (testSuiteId != null ? 1 : 0);
            writable.startMap(fieldCount);
            if (testSessionId != null) {
                writable.writeUTF8(TEST_SESSION_ID);
                writable.writeLong(testSessionId);
            }
            if (testSuiteId != null) {
                writable.writeUTF8(TEST_SUITE_ID);
                writable.writeLong(testSuiteId);
            }
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(testReport.getSpanId());
            Collection<TestReportFileEntry> fileEntries = testReport.getTestReportFileEntries();
            writable.writeUTF8(FILES);
            writable.startArray(fileEntries.size());
            for (TestReportFileEntry entry : fileEntries) {
                writable.startMap(2);
                writable.writeUTF8(FILENAME);
                writable.writeString(entry.getSourceFileName(), null);
                Collection<TestReportFileEntry.Segment> segments = entry.getSegments();
                writable.writeUTF8(SEGMENTS);
                writable.startArray(segments.size());
                for (TestReportFileEntry.Segment segment : segments) {
                    writable.startArray(5);
                    writable.writeInt(segment.getStartLine());
                    writable.writeInt(segment.getStartColumn());
                    writable.writeInt(segment.getEndLine());
                    writable.writeInt(segment.getEndColumn());
                    writable.writeInt(segment.getNumberOfExecutions());
                }
            }
        }
        this.eventCount += testReports.size();
    }

    private static TestReport getTestReport(CoreSpan<?> span) {
        TestReportHolder probes;
        if (span instanceof AgentSpan && (probes = (TestReportHolder)((AgentSpan)((Object)span)).getRequestContext().getData(RequestContextSlot.CI_VISIBILITY)) != null) {
            return probes.getReport();
        }
        return null;
    }

    private void writeHeader() {
        this.headerWriter.startMap(2);
        this.headerWriter.writeUTF8(VERSION);
        this.headerWriter.writeInt(2);
        this.headerWriter.writeUTF8(COVERAGES);
        this.headerWriter.startArray(this.eventCount);
    }

    @Override
    public Payload newPayload() {
        this.writeHeader();
        return new PayloadV2().withHeader(this.headerBuffer.slice());
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
        this.eventCount = 0;
    }

    @Override
    public String endpoint() {
        return (Object)((Object)TrackType.CITESTCOV) + "/v2";
    }

    private static class PayloadV2
    extends Payload {
        private static final RequestBody DUMMY_JSON_BODY = OkHttpUtils.jsonRequestBodyOf("{\"dummy\":true}".getBytes());
        ByteBuffer header = null;

        private PayloadV2() {
        }

        PayloadV2 withHeader(ByteBuffer header) {
            this.header = header;
            return this;
        }

        @Override
        public int sizeInBytes() {
            if (this.traceCount() == 0) {
                return this.msgpackMapHeaderSize(0);
            }
            int size = this.body.remaining();
            if (this.header != null) {
                size += this.header.remaining();
            }
            return size;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer emptyDict = this.msgpackMapHeader(0);
                while (emptyDict.hasRemaining()) {
                    channel.write(emptyDict);
                }
            } else {
                if (this.header != null) {
                    while (this.header.hasRemaining()) {
                        channel.write(this.header);
                    }
                }
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            RequestBody coverageBody = this.traceCount() == 0 ? OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.msgpackMapHeader(0))) : (this.header != null ? OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.header, this.body)) : OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.body)));
            return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("coverage1", "coverage1.msgpack", coverageBody).addFormDataPart("event", "event.json", DUMMY_JSON_BODY).build();
        }
    }
}

