/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamContextInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStreamContextInjector.class);
    private final DataStreamsMonitoring dataStreamsMonitoring;

    public DataStreamContextInjector(DataStreamsMonitoring dataStreamsMonitoring) {
        this.dataStreamsMonitoring = dataStreamsMonitoring;
    }

    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        boolean injected;
        PathwayContext pathwayContext = span.context().getPathwayContext();
        if (pathwayContext == null) {
            return;
        }
        pathwayContext.setCheckpoint(sortedTags, this.dataStreamsMonitoring::add);
        boolean bl = injected = setter instanceof AgentPropagation.BinarySetter ? DataStreamContextInjector.injectBinaryPathwayContext(pathwayContext, carrier, (AgentPropagation.BinarySetter)setter) : DataStreamContextInjector.injectPathwayContext(pathwayContext, carrier, setter);
        if (injected && pathwayContext.getHash() != 0L) {
            span.setTag("pathway.hash", Long.toUnsignedString(pathwayContext.getHash()));
        }
    }

    private static <C> boolean injectBinaryPathwayContext(PathwayContext pathwayContext, C carrier, AgentPropagation.BinarySetter<C> setter) {
        try {
            byte[] encodedContext = pathwayContext.encode();
            if (encodedContext != null) {
                LOGGER.debug("Injecting binary pathway context {}", (Object)pathwayContext);
                setter.set(carrier, "dd-pathway-ctx-base64", encodedContext);
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Unable to set encode pathway context", (Throwable)e);
        }
        return false;
    }

    private static <C> boolean injectPathwayContext(PathwayContext pathwayContext, C carrier, AgentPropagation.Setter<C> setter) {
        try {
            String encodedContext = pathwayContext.strEncode();
            if (encodedContext != null) {
                LOGGER.debug("Injecting pathway context {}", (Object)pathwayContext);
                setter.set(carrier, "dd-pathway-ctx-base64", encodedContext);
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Unable to set encode pathway context", (Throwable)e);
        }
        return false;
    }
}

