/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.interceptor;

import datadog.trace.api.interceptor.AbstractTraceInterceptor;
import datadog.trace.api.interceptor.MutableSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import java.util.Collection;
import java.util.Collections;

public class CiVisibilityTraceInterceptor
extends AbstractTraceInterceptor {
    public static final CiVisibilityTraceInterceptor INSTANCE = new CiVisibilityTraceInterceptor(AbstractTraceInterceptor.Priority.CI_VISIBILITY_TRACE);
    static final UTF8BytesString CIAPP_TEST_ORIGIN = UTF8BytesString.create("ciapp-test");

    protected CiVisibilityTraceInterceptor(AbstractTraceInterceptor.Priority priority) {
        super(priority);
    }

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        if (trace.isEmpty()) {
            return trace;
        }
        DDSpan firstSpan = (DDSpan)trace.iterator().next();
        DDSpan localRootSpan = firstSpan.getLocalRootSpan();
        DDSpan spanToCheck = null == localRootSpan ? firstSpan : localRootSpan;
        CharSequence type = spanToCheck.getType();
        if (type == null || !"test".contentEquals(type) && !"test_suite_end".contentEquals(type) && !"test_module_end".contentEquals(type) && !"test_session_end".contentEquals(type)) {
            return Collections.emptyList();
        }
        firstSpan.context().setOrigin(CIAPP_TEST_ORIGIN);
        firstSpan.setTag("library_version", DDTraceCoreInfo.VERSION);
        for (MutableSpan mutableSpan : trace) {
            mutableSpan.setTag("library_version", DDTraceCoreInfo.VERSION);
        }
        return trace;
    }
}

