/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.ToJson;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLink;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DDSpanLink
extends SpanLink {
    private static final Moshi MOSHI = new Moshi.Builder().add(new SpanLinkAdapter()).build();
    private static final JsonAdapter<List<AgentSpanLink>> SPAN_LINKS_ADAPTER = MOSHI.adapter(Types.newParameterizedType(List.class, new Type[]{AgentSpanLink.class}));

    protected DDSpanLink(DDTraceId traceId, long spanId, String traceState, Map<String, String> attributes) {
        super(traceId, spanId, traceState, attributes);
    }

    public static SpanLink from(ExtractedContext context) {
        return DDSpanLink.from(context, Collections.emptyMap());
    }

    public static SpanLink from(ExtractedContext context, Map<String, String> attributes) {
        String traceState = context.getPropagationTags() == null ? "" : context.getPropagationTags().headerValue(PropagationTags.HeaderType.W3C);
        return new DDSpanLink(context.getTraceId(), context.getSpanId(), traceState, attributes);
    }

    public static String toTag(List<AgentSpanLink> links) {
        if (links == null || links.isEmpty()) {
            return null;
        }
        return SPAN_LINKS_ADAPTER.toJson(links);
    }

    private static class SpanLinkJson {
        String traceId;
        String spanId;
        String traceState;
        Map<String, String> attributes;

        private SpanLinkJson() {
        }
    }

    private static class SpanLinkAdapter {
        private SpanLinkAdapter() {
        }

        @ToJson
        SpanLinkJson toSpanLinkJson(AgentSpanLink link) {
            SpanLinkJson json = new SpanLinkJson();
            json.traceId = link.traceId().toHexString();
            json.spanId = DDSpanId.toHexString((long)link.spanId());
            json.traceState = link.traceState();
            if (!link.attributes().isEmpty()) {
                json.attributes = link.attributes();
            }
            return json;
        }

        @FromJson
        AgentSpanLink fromSpanLinkJson(SpanLinkJson json) {
            return new DDSpanLink(DDTraceId.fromHex((String)json.traceId), DDSpanId.fromHex((String)json.spanId), json.traceState, json.attributes);
        }
    }
}

