/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.util;

public class Cookie {
    private final String cookieName;
    private final boolean secure;
    private final String sameSite;
    private final boolean httpOnly;

    public Cookie(String cookieName, boolean secure, boolean httpOnly, String sameSite) {
        this.cookieName = cookieName;
        this.secure = secure;
        this.sameSite = sameSite;
        this.httpOnly = httpOnly;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public static Builder named(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private boolean secure = false;
        private boolean httpOnly = false;
        private String sameSite = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder sameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.secure, this.httpOnly, this.sameSite);
        }
    }
}

