/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DD128bTraceId;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.internal.util.LongStringUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class W3CHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(W3CHttpCodec.class);
    static final String TRACE_PARENT_KEY = "traceparent";
    static final String TRACE_STATE_KEY = "tracestate";
    static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String E2E_START_KEY = "ot-baggage-t0";
    private static final int TRACE_PARENT_TID_START = 3;
    private static final int TRACE_PARENT_TID_END = 35;
    private static final int TRACE_PARENT_SID_START = 36;
    private static final int TRACE_PARENT_SID_END = 52;
    private static final int TRACE_PARENT_FLAGS_START = 53;
    private static final int TRACE_PARENT_FLAGS_SAMPLED = 1;
    private static final int TRACE_PARENT_LENGTH = 55;

    private W3CHttpCodec() {
    }

    public static HttpCodec.Injector newInjector(Map<String, String> invertedBaggageMapping) {
        return new Injector(invertedBaggageMapping);
    }

    public static HttpCodec.Extractor newExtractor(Config config, Supplier<TraceConfig> traceConfigSupplier) {
        return new TagContextExtractor(traceConfigSupplier, () -> new W3CContextInterpreter(config));
    }

    private static class W3CContextInterpreter
    extends ContextInterpreter {
        private static final int TRACE_PARENT = 0;
        private static final int TRACE_STATE = 1;
        private static final int OT_BAGGAGE = 2;
        private static final int E2E_START = 3;
        private static final int IGNORE = -1;
        private final PropagationTags.Factory datadogTagsFactory;
        private String tracestateHeader = null;
        private String traceparentHeader = null;

        private W3CContextInterpreter(Config config) {
            super(config);
            this.datadogTagsFactory = PropagationTags.factory(config);
        }

        @Override
        public ContextInterpreter reset(TraceConfig traceConfig) {
            this.tracestateHeader = null;
            this.traceparentHeader = null;
            return super.reset(traceConfig);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            String lowerCaseKey = null;
            int classification = -1;
            char first = Character.toLowerCase(key.charAt(0));
            switch (first) {
                case 'f': {
                    if (!this.handledForwarding(key, value)) break;
                    return true;
                }
                case 'o': {
                    lowerCaseKey = this.toLowerCase(key);
                    if (W3CHttpCodec.E2E_START_KEY.equals(lowerCaseKey)) {
                        classification = 3;
                        break;
                    }
                    if (!lowerCaseKey.startsWith(W3CHttpCodec.OT_BAGGAGE_PREFIX)) break;
                    classification = 2;
                    break;
                }
                case 't': {
                    if (W3CHttpCodec.TRACE_PARENT_KEY.equalsIgnoreCase(key)) {
                        classification = 0;
                        break;
                    }
                    if (!W3CHttpCodec.TRACE_STATE_KEY.equalsIgnoreCase(key)) break;
                    classification = 1;
                    break;
                }
                case 'u': {
                    if (!this.handledUserAgent(key, value)) break;
                    return true;
                }
                case 'x': {
                    if (!this.handledXForwarding(key, value)) break;
                    return true;
                }
            }
            if (classification != -1) {
                try {
                    if (null == value) return true;
                    switch (classification) {
                        case 0: {
                            return this.storeTraceParent(value);
                        }
                        case 1: {
                            return this.storeTraceState(value);
                        }
                        case 3: {
                            this.endToEndStartTime = this.extractEndToEndStartTime(HttpCodec.firstHeaderValue(value));
                            return true;
                        }
                        case 2: {
                            if (this.baggage.isEmpty()) {
                                this.baggage = new TreeMap();
                            }
                            this.baggage.put(lowerCaseKey.substring(W3CHttpCodec.OT_BAGGAGE_PREFIX.length()), HttpCodec.decode(value));
                            return true;
                        }
                    }
                    return true;
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", (Throwable)e);
                    return false;
                }
            } else {
                if (this.handledIpHeaders(key, value)) {
                    return true;
                }
                if (this.handleTags(key, value)) {
                    return true;
                }
                this.handleMappedBaggage(key, value);
            }
            return true;
        }

        private long extractEndToEndStartTime(String value) {
            try {
                return TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value));
            }
            catch (RuntimeException e) {
                log.debug("Ignoring invalid end-to-end start time {}", (Object)value, (Object)e);
                return 0L;
            }
        }

        private boolean storeTraceParent(String value) {
            String trimmed = W3CContextInterpreter.trim(value);
            if (this.traceparentHeader != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Multiple traceparent headers. Had '{}' and got '{}'", (Object)this.traceparentHeader, (Object)trimmed);
                }
                this.onlyTagContext();
            } else {
                this.traceparentHeader = trimmed;
            }
            return true;
        }

        private boolean storeTraceState(String value) {
            String trimmed = W3CContextInterpreter.trim(value);
            if (!trimmed.isEmpty()) {
                this.tracestateHeader = this.tracestateHeader == null ? trimmed : this.tracestateHeader + "," + trimmed;
            }
            return true;
        }

        @Override
        protected TagContext build() {
            if (this.traceparentHeader == null && this.tracestateHeader == null) {
                this.onlyTagContext();
            }
            if (this.valid && this.fullContext) {
                try {
                    if (this.traceparentHeader == null && this.tracestateHeader != null) {
                        throw new IllegalStateException("Found no traceparent header but tracestate header '" + this.tracestateHeader + "'");
                    }
                    W3CContextInterpreter.parseTraceParentHeader(this.traceparentHeader, this);
                    W3CContextInterpreter.parseTraceStateHeader(this.tracestateHeader, this, this.datadogTagsFactory);
                }
                catch (RuntimeException e) {
                    this.onlyTagContext();
                    log.debug("Exception when building context", (Throwable)e);
                }
            }
            return super.build();
        }

        static void parseTraceParentHeader(String tp, ContextInterpreter context) {
            int length;
            int n = length = tp == null ? 0 : tp.length();
            if (length < 55) {
                throw new IllegalStateException("The length of traceparent '" + tp + "' is too short");
            }
            long version = LongStringUtils.parseUnsignedLongHex((CharSequence)tp, (int)0, (int)2, (boolean)true);
            if (version == 255L) {
                throw new IllegalStateException("Illegal version number " + tp.substring(0, 2));
            }
            if (version == 0L && length > 55) {
                throw new IllegalStateException("The length of traceparent '" + tp + "' is too long");
            }
            DD128bTraceId traceId = DD128bTraceId.fromHex((String)tp, (int)3, (int)32, (boolean)true);
            if (traceId.toLong() == 0L) {
                throw new IllegalStateException("Illegal all zero 64 bit trace id " + tp.substring(3, 35));
            }
            context.traceId = traceId;
            context.spanId = DDSpanId.fromHex((String)tp, (int)36, (int)16, (boolean)true);
            if (context.spanId == 0L) {
                throw new IllegalStateException("Illegal all zero span id " + tp.substring(36, 52));
            }
            if (version != 0L && length > 55 && tp.charAt(55) != '-') {
                throw new IllegalStateException("Illegal character after flags in '" + tp + "'");
            }
            long flags = LongStringUtils.parseUnsignedLongHex((CharSequence)tp, (int)53, (int)2, (boolean)true);
            context.samplingPriority = (flags & 1L) != 0L ? 1 : 0;
        }

        static void parseTraceStateHeader(String ts, ContextInterpreter context, PropagationTags.Factory factory) {
            context.propagationTags = ts == null || ts.isEmpty() ? factory.empty() : factory.fromHeaderValue(PropagationTags.HeaderType.W3C, ts);
            int ptagsPriority = context.propagationTags.getSamplingPriority();
            int contextPriority = context.samplingPriority;
            if (contextPriority == 0 && ptagsPriority > 0 || contextPriority == 1 && ptagsPriority <= 0 || ptagsPriority == -128) {
                context.propagationTags.updateTraceSamplingPriority(contextPriority, -128);
            } else {
                context.samplingPriority = ptagsPriority;
            }
            context.origin = context.propagationTags.getOrigin();
            context.propagationTags.updateTraceIdHighOrderBits(context.traceId.toHighOrderLong());
        }

        private static String trim(String input) {
            char c;
            int end;
            char c2;
            int start;
            if (input == null) {
                return "";
            }
            int last = input.length() - 1;
            if (last == 0) {
                return input;
            }
            for (start = 0; start <= last && ((c2 = input.charAt(start)) == '\t' || c2 == ' '); ++start) {
            }
            for (end = last; end > start && ((c = input.charAt(end)) == '\t' || c == ' '); --end) {
            }
            if (start == 0 && end == last) {
                return input;
            }
            return input.substring(start, end + 1);
        }
    }

    private static class Injector
    implements HttpCodec.Injector {
        private final Map<String, String> invertedBaggageMapping;

        public Injector(Map<String, String> invertedBaggageMapping) {
            assert (invertedBaggageMapping != null);
            this.invertedBaggageMapping = invertedBaggageMapping;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            long e2eStart;
            StringBuilder sb = new StringBuilder(55);
            sb.append("00-");
            sb.append(context.getTraceId().toHexString());
            sb.append("-");
            sb.append(DDSpanId.toHexStringPadded((long)context.getSpanId()));
            sb.append(context.getSamplingPriority() > 0 ? "-01" : "-00");
            setter.set(carrier, W3CHttpCodec.TRACE_PARENT_KEY, sb.toString());
            String tracestate = context.getPropagationTags().headerValue(PropagationTags.HeaderType.W3C);
            if (tracestate != null && !tracestate.isEmpty()) {
                setter.set(carrier, W3CHttpCodec.TRACE_STATE_KEY, tracestate);
            }
            if ((e2eStart = context.getEndToEndStartTime()) > 0L) {
                setter.set(carrier, W3CHttpCodec.E2E_START_KEY, Long.toString(TimeUnit.NANOSECONDS.toMillis(e2eStart)));
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                String header = this.invertedBaggageMapping.get(entry.getKey());
                header = header != null ? header : W3CHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey();
                setter.set(carrier, header, HttpCodec.encodeBaggage(entry.getValue()));
            }
        }
    }
}

