/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.lambda;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.lambda.ReadFromInputStreamJsonAdapter;
import ddtrot.dd.trace.lambda.SkipUnsupportedTypeJsonAdapter;
import ddtrot.okhttp3.MediaType;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okhttp3.Response;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaHandler {
    private static final Logger log = LoggerFactory.getLogger(LambdaHandler.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_TRACE_ID = "x-datadog-trace-id";
    private static final String DATADOG_SPAN_ID = "x-datadog-span-id";
    private static final String DATADOG_SAMPLING_PRIORITY = "x-datadog-sampling-priority";
    private static final String DATADOG_INVOCATION_ERROR = "x-datadog-invocation-error";
    private static final String DATADOG_TAGS_KEY = "x-datadog-tags";
    private static final String START_INVOCATION = "/lambda/start-invocation";
    private static final String END_INVOCATION = "/lambda/end-invocation";
    private static final Long REQUEST_TIMEOUT_IN_S = 1L;
    private static OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(REQUEST_TIMEOUT_IN_S, TimeUnit.SECONDS).writeTimeout(REQUEST_TIMEOUT_IN_S, TimeUnit.SECONDS).readTimeout(REQUEST_TIMEOUT_IN_S, TimeUnit.SECONDS).callTimeout(REQUEST_TIMEOUT_IN_S, TimeUnit.SECONDS).build();
    private static final MediaType jsonMediaType = MediaType.parse("application/json");
    private static final JsonAdapter<Object> adapter = new Moshi.Builder().add((Type)((Object)ByteArrayInputStream.class), new ReadFromInputStreamJsonAdapter()).add(SkipUnsupportedTypeJsonAdapter.newFactory()).build().adapter(Object.class);
    private static String EXTENSION_BASE_URL = "http://127.0.0.1:8124";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AgentSpan.Context notifyStartInvocation(Object event, PropagationTags.Factory propagationTagsFactory) {
        RequestBody body = RequestBody.create(jsonMediaType, LambdaHandler.writeValueAsString(event));
        try (Response response = HTTP_CLIENT.newCall(new Request.Builder().url(EXTENSION_BASE_URL + START_INVOCATION).addHeader(DATADOG_META_LANG, "java").post(body).build()).execute();){
            if (!response.isSuccessful()) return null;
            String traceID = response.headers().get(DATADOG_TRACE_ID);
            String priority = response.headers().get(DATADOG_SAMPLING_PRIORITY);
            if (null != traceID && null != priority) {
                int samplingPriority = -128;
                try {
                    samplingPriority = Integer.parseInt(priority);
                }
                catch (NumberFormatException ignored) {
                    log.warn("could not read the sampling priority, defaulting to UNSET");
                }
                log.debug("notifyStartInvocation success, found traceID = {} and samplingPriority = {}", (Object)traceID, (Object)samplingPriority);
                PropagationTags propagationTags = propagationTagsFactory.fromHeaderValue(PropagationTags.HeaderType.DATADOG, response.headers().get(DATADOG_TAGS_KEY));
                ExtractedContext extractedContext = new ExtractedContext(DDTraceId.from((String)traceID), 0L, samplingPriority, null, propagationTags);
                return extractedContext;
            }
            log.debug("could not find traceID or sampling priority in notifyStartInvocation, not injecting the context");
            return null;
        }
        catch (Throwable ignored) {
            log.error("could not reach the extension");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean notifyEndInvocation(AgentSpan span, Object result, boolean isError) {
        if (null == span || null == span.getSamplingPriority()) {
            log.error("could not notify the extension as the lambda span is null or no sampling priority has been found");
            return false;
        }
        RequestBody body = RequestBody.create(jsonMediaType, LambdaHandler.writeValueAsString(result));
        Request.Builder builder = new Request.Builder().url(EXTENSION_BASE_URL + END_INVOCATION).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_TRACE_ID, span.getTraceId().toString()).addHeader(DATADOG_SPAN_ID, DDSpanId.toString((long)span.getSpanId())).addHeader(DATADOG_SAMPLING_PRIORITY, span.getSamplingPriority().toString()).addHeader(DATADOG_META_LANG, "java").post(body);
        if (isError) {
            builder.addHeader(DATADOG_INVOCATION_ERROR, "true");
        }
        try (Response response = HTTP_CLIENT.newCall(builder.build()).execute();){
            if (!response.isSuccessful()) return false;
            log.debug("notifyEndInvocation success");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("could not reach the extension, not injecting the context", (Throwable)e);
        }
        return false;
    }

    public static String writeValueAsString(Object obj) {
        String json = "{}";
        if (null != obj) {
            try {
                json = adapter.toJson(obj);
            }
            catch (Exception e) {
                log.debug("could not write the value into a string", (Throwable)e);
            }
        }
        return json;
    }

    public static void setExtensionBaseUrl(String extensionBaseUrl) {
        EXTENSION_BASE_URL = extensionBaseUrl;
    }
}

