/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility;

import ddtrot.dd.trace.api.civisibility.coverage.CoverageDataSupplier;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageProbeStore;
import ddtrot.dd.trace.api.civisibility.events.BuildEventsHandler;
import ddtrot.dd.trace.api.civisibility.events.TestEventsHandler;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.nio.file.Path;

public abstract class InstrumentationBridge {
    public static final String ITR_SKIP_REASON = "Skipped by Datadog Intelligent Test Runner";
    public static final String ITR_UNSKIPPABLE_TAG = "datadog_itr_unskippable";
    private static volatile TestEventsHandler.Factory TEST_EVENTS_HANDLER_FACTORY;
    private static volatile BuildEventsHandler.Factory BUILD_EVENTS_HANDLER_FACTORY;
    private static volatile CoverageProbeStore.Registry COVERAGE_PROBE_STORE_REGISTRY;
    private static volatile CoverageDataSupplier COVERAGE_DATA_SUPPLIER;

    public static void registerTestEventsHandlerFactory(TestEventsHandler.Factory testEventsHandlerFactory) {
        TEST_EVENTS_HANDLER_FACTORY = testEventsHandlerFactory;
    }

    public static TestEventsHandler createTestEventsHandler(String component, Path path) {
        return TEST_EVENTS_HANDLER_FACTORY.create(component, path);
    }

    public static void registerBuildEventsHandlerFactory(BuildEventsHandler.Factory buildEventsHandlerFactory) {
        BUILD_EVENTS_HANDLER_FACTORY = buildEventsHandlerFactory;
    }

    public static <U> BuildEventsHandler<U> createBuildEventsHandler() {
        return BUILD_EVENTS_HANDLER_FACTORY.create();
    }

    public static void registerCoverageProbeStoreRegistry(CoverageProbeStore.Registry coverageProbeStoreRegistry) {
        COVERAGE_PROBE_STORE_REGISTRY = coverageProbeStoreRegistry;
    }

    public static CoverageProbeStore.Registry getCoverageProbeStoreRegistry() {
        return COVERAGE_PROBE_STORE_REGISTRY;
    }

    public static void registerCoverageDataSupplier(CoverageDataSupplier coverageDataSupplier) {
        COVERAGE_DATA_SUPPLIER = coverageDataSupplier;
    }

    public static byte[] getCoverageData() {
        return COVERAGE_DATA_SUPPLIER != null ? COVERAGE_DATA_SUPPLIER.get() : null;
    }

    public static void currentCoverageProbeStoreRecord(long classId, String className, Class<?> clazz, int probeId) {
        AgentSpan span = AgentTracer.activeSpan();
        if (span == null) {
            return;
        }
        RequestContext requestContext = span.getRequestContext();
        if (requestContext == null) {
            return;
        }
        CoverageProbeStore probes = (CoverageProbeStore)requestContext.getData(RequestContextSlot.CI_VISIBILITY);
        if (probes != null) {
            probes.record(clazz, classId, className, probeId);
        }
    }
}

