/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import ddtrot.dd.common.container.ServerlessInfo;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.writer.DDAgentWriter;
import ddtrot.dd.trace.common.writer.DDIntakeWriter;
import ddtrot.dd.trace.common.writer.LoggingWriter;
import ddtrot.dd.trace.common.writer.MultiWriter;
import ddtrot.dd.trace.common.writer.PrintingWriter;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.dd.trace.common.writer.RemoteWriter;
import ddtrot.dd.trace.common.writer.TraceStructureWriter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.common.writer.ddagent.DDAgentApi;
import ddtrot.dd.trace.common.writer.ddagent.Prioritization;
import ddtrot.dd.trace.common.writer.ddintake.DDEvpProxyApi;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeApi;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeTrackTypeResolver;
import ddtrot.dd.trace.core.monitor.TracerHealthMetrics;
import ddtrot.dd.trace.util.Strings;
import ddtrot.okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactory {
    private static final Logger log = LoggerFactory.getLogger(WriterFactory.class);

    public static Writer createWriter(Config config, SharedCommunicationObjects commObjects, Sampler sampler, SingleSpanSampler singleSpanSampler, StatsDClient statsDClient) {
        return WriterFactory.createWriter(config, commObjects, sampler, singleSpanSampler, statsDClient, config.getWriterType());
    }

    public static Writer createWriter(Config config, SharedCommunicationObjects commObjects, Sampler sampler, SingleSpanSampler singleSpanSampler, StatsDClient statsDClient, String configuredType) {
        RemoteWriter remoteWriter;
        Prioritization prioritization;
        if ("LoggingWriter".equals(configuredType)) {
            return new LoggingWriter();
        }
        if ("PrintingWriter".equals(configuredType)) {
            return new PrintingWriter(System.out, true);
        }
        if (configuredType.startsWith("TraceStructureWriter")) {
            return new TraceStructureWriter(Strings.replace(configuredType, "TraceStructureWriter", ""));
        }
        if (configuredType.startsWith("MultiWriter")) {
            return new MultiWriter(config, commObjects, sampler, singleSpanSampler, statsDClient, configuredType);
        }
        if (!"DDAgentWriter".equals(configuredType) && !"DDIntakeWriter".equals(configuredType)) {
            log.warn("Writer type not configured correctly: Type {} not recognized. Ignoring", (Object)configuredType);
            configuredType = "DDAgentWriter";
        }
        if (Prioritization.ENSURE_TRACE == (prioritization = config.getEnumValue("prioritization.type", Prioritization.class, Prioritization.FAST_LANE))) {
            log.info("Using 'EnsureTrace' prioritization type. (Do not use this type if your application is running in production mode)");
        }
        int flushIntervalMilliseconds = Math.round(config.getTraceFlushIntervalSeconds() * 1000.0f);
        DDAgentFeaturesDiscovery featuresDiscovery = commObjects.featuresDiscovery(config);
        if ("DDAgentWriter".equals(configuredType) && config.isCiVisibilityEnabled()) {
            if (featuresDiscovery.supportsEvpProxy() || config.isCiVisibilityAgentlessEnabled()) {
                configuredType = "DDIntakeWriter";
            } else {
                log.info("CI Visibility functionality is limited. Please upgrade to Agent v6.40+ or v7.40+ or enable Agentless mode.");
            }
        }
        if ("DDIntakeWriter".equals(configuredType)) {
            TrackType trackType = DDIntakeTrackTypeResolver.resolve(config);
            RemoteApi remoteApi = WriterFactory.createDDIntakeRemoteApi(config, commObjects, featuresDiscovery, trackType);
            DDIntakeWriter.DDIntakeWriterBuilder builder = DDIntakeWriter.builder().addTrack(trackType, remoteApi).prioritization(prioritization).healthMetrics(new TracerHealthMetrics(statsDClient)).monitoring(commObjects.monitoring).singleSpanSampler(singleSpanSampler).flushIntervalMilliseconds(flushIntervalMilliseconds);
            if (config.isCiVisibilityCodeCoverageEnabled()) {
                RemoteApi coverageApi = WriterFactory.createDDIntakeRemoteApi(config, commObjects, featuresDiscovery, TrackType.CITESTCOV);
                builder.addTrack(TrackType.CITESTCOV, coverageApi);
            }
            remoteWriter = builder.build();
        } else {
            boolean alwaysFlush = false;
            if (config.isAgentConfiguredUsingDefault() && ServerlessInfo.get().isRunningInServerlessEnvironment()) {
                if (!ServerlessInfo.get().hasExtension()) {
                    log.info("Detected serverless environment. Serverless extension has not been detected, using PrintingWriter");
                    return new PrintingWriter(System.out, true);
                }
                log.info("Detected serverless environment. Serverless extension has been detected, using DDAgentWriter");
                alwaysFlush = true;
            }
            DDAgentApi ddAgentApi = new DDAgentApi(commObjects.okHttpClient, commObjects.agentUrl, featuresDiscovery, commObjects.monitoring, config.isTracerMetricsEnabled());
            if (sampler instanceof RemoteResponseListener) {
                ddAgentApi.addResponseListener((RemoteResponseListener)((Object)sampler));
            }
            remoteWriter = DDAgentWriter.builder().agentApi(ddAgentApi).featureDiscovery(featuresDiscovery).prioritization(prioritization).healthMetrics(new TracerHealthMetrics(statsDClient)).monitoring(commObjects.monitoring).alwaysFlush(alwaysFlush).spanSamplingRules(singleSpanSampler).flushIntervalMilliseconds(flushIntervalMilliseconds).build();
        }
        return remoteWriter;
    }

    private static RemoteApi createDDIntakeRemoteApi(Config config, SharedCommunicationObjects commObjects, DDAgentFeaturesDiscovery featuresDiscovery, TrackType trackType) {
        if (featuresDiscovery.supportsEvpProxy() && !config.isCiVisibilityAgentlessEnabled()) {
            return DDEvpProxyApi.builder().httpClient(commObjects.okHttpClient).agentUrl(commObjects.agentUrl).evpProxyEndpoint(featuresDiscovery.getEvpProxyEndpoint()).trackType(trackType).build();
        }
        HttpUrl hostUrl = null;
        if (config.getCiVisibilityAgentlessUrl() != null) {
            hostUrl = HttpUrl.get(config.getCiVisibilityAgentlessUrl());
            log.info("Using host URL '{}' to report CI Visibility traces in Agentless mode.", (Object)hostUrl);
        }
        return DDIntakeApi.builder().hostUrl(hostUrl).apiKey(config.getApiKey()).trackType(trackType).build();
    }

    private WriterFactory() {
    }
}

