/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.scopemanager.ExtendedScopeListener;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScopeManager;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeState;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.core.scopemanager.AbstractContinuation;
import ddtrot.dd.trace.core.scopemanager.ContinuableScope;
import ddtrot.dd.trace.core.scopemanager.ContinuingScope;
import ddtrot.dd.trace.core.scopemanager.ScopeStack;
import ddtrot.dd.trace.core.scopemanager.SingleContinuation;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContinuableScopeManager
implements AgentScopeManager {
    static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    static final RatelimitedLogger ratelimitedLog = new RatelimitedLogger(log, 1, TimeUnit.MINUTES);
    static final long iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    volatile ConcurrentMap<ScopeStack, ContinuableScope> rootIterationScopes;
    final List<ScopeListener> scopeListeners;
    final List<ExtendedScopeListener> extendedScopeListeners;
    final boolean strictMode;
    private final ScopeStackThreadLocal tlsScopeStack;
    private final int depthLimit;
    private final boolean inheritAsyncPropagation;
    final HealthMetrics healthMetrics;

    public ContinuableScopeManager(int depthLimit, boolean strictMode, boolean inheritAsyncPropagation) {
        this(depthLimit, strictMode, inheritAsyncPropagation, ProfilingContextIntegration.NoOp.INSTANCE, HealthMetrics.NO_OP);
    }

    public ContinuableScopeManager(int depthLimit, boolean strictMode, boolean inheritAsyncPropagation, ProfilingContextIntegration profilingContextIntegration, HealthMetrics healthMetrics) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.strictMode = strictMode;
        this.inheritAsyncPropagation = inheritAsyncPropagation;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
        this.healthMetrics = healthMetrics;
        this.tlsScopeStack = new ScopeStackThreadLocal(profilingContextIntegration);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        return this.activate(span, source.id(), false, false);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.activate(span, source.id(), true, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span) {
        SingleContinuation continuation = new SingleContinuation(this, span, ScopeSource.INSTRUMENTATION.id());
        continuation.register();
        this.healthMetrics.onCaptureContinuation();
        return continuation;
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true);
        ContinuableScope scope = new ContinuableScope(this, span, source, asyncPropagation);
        scopeStack.push(scope);
        this.healthMetrics.onActivateScope();
        return scope;
    }

    ContinuableScope continueSpan(AbstractContinuation continuation, AgentSpan span, byte source) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            if (continuation != null) {
                continuation.cancelFromContinuedScopeClose();
            }
            return top;
        }
        ContinuableScope scope = continuation != null ? new ContinuingScope(this, span, source, true, continuation) : new ContinuableScope(this, span, source, true);
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.source() == ScopeSource.ITERATION.id()) {
            if (iterationKeepAlive > 0L) {
                this.cancelRootIterationScopeCleanup(scopeStack, top);
            }
            top.close();
            scopeStack.cleanup();
            if (finishSpan) {
                top.span.finishWithEndToEnd();
                this.healthMetrics.onFinishContinuation();
            }
        }
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        ScopeStack scopeStack = this.scopeStack();
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        ContinuableScope top = scopeStack.top;
        boolean asyncPropagation = this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, span, ScopeSource.ITERATION.id(), asyncPropagation);
        if (iterationKeepAlive > 0L && currentDepth == 0) {
            this.scheduleRootIterationScopeCleanup(scopeStack, scope);
        }
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public AgentScope active() {
        return this.scopeStack().active();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? null : active.span;
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && activeSpan != AgentTracer.NoopAgentSpan.INSTANCE) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.getLocalRootSpan().getSpanId(), activeSpan.context().getSpanId(), activeSpan.traceConfig());
        }
    }

    ScopeStack scopeStack() {
        return (ScopeStack)this.tlsScopeStack.get();
    }

    @Override
    public ScopeState newScopeState() {
        return new ContinuableScopeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes == null) {
            ContinuableScopeManager continuableScopeManager = this;
            synchronized (continuableScopeManager) {
                if (this.rootIterationScopes == null) {
                    this.rootIterationScopes = new ConcurrentHashMap<ScopeStack, ContinuableScope>();
                    RootIterationCleaner.scheduleFor(this.rootIterationScopes);
                }
            }
        }
        this.rootIterationScopes.put(scopeStack, scope);
    }

    private void cancelRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes != null) {
            this.rootIterationScopes.remove(scopeStack, scope);
        }
    }

    private static final class RootIterationCleaner
    implements AgentTaskScheduler.Task<Map<ScopeStack, ContinuableScope>> {
        private static final RootIterationCleaner CLEANER = new RootIterationCleaner();

        private RootIterationCleaner() {
        }

        public static void scheduleFor(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, rootIterationScopes, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            Iterator<Map.Entry<ScopeStack, ContinuableScope>> itr = rootIterationScopes.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<ScopeStack, ContinuableScope> entry = itr.next();
                ScopeStack scopeStack = entry.getKey();
                ContinuableScope rootScope = entry.getValue();
                if (!rootScope.alive()) {
                    itr.remove();
                    continue;
                }
                if (TimeUnit.NANOSECONDS.toMillis(rootScope.span.getStartTime()) >= cutOff) continue;
                scopeStack.overdueRootScope = rootScope;
                rootScope.span.finishWithEndToEnd();
                itr.remove();
            }
        }
    }

    static final class ScopeStackThreadLocal
    extends ThreadLocal<ScopeStack> {
        private final ProfilingContextIntegration profilingContextIntegration;

        ScopeStackThreadLocal(ProfilingContextIntegration profilingContextIntegration) {
            this.profilingContextIntegration = profilingContextIntegration;
        }

        @Override
        protected ScopeStack initialValue() {
            return new ScopeStack(this.profilingContextIntegration);
        }
    }

    private class ContinuableScopeState
    implements ScopeState {
        private ScopeStack localScopeStack;

        private ContinuableScopeState() {
            this.localScopeStack = ContinuableScopeManager.this.tlsScopeStack.initialValue();
        }

        @Override
        public void activate() {
            ContinuableScopeManager.this.tlsScopeStack.set(this.localScopeStack);
        }

        @Override
        public void fetchFromActive() {
            this.localScopeStack = (ScopeStack)ContinuableScopeManager.this.tlsScopeStack.get();
        }
    }
}

