/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v1;

import ddtrot.dd.trace.api.naming.NamingSchema;
import javax.annotation.Nonnull;

public class MessagingNamingV1
implements NamingSchema.ForMessaging {
    private String normalizeForCloud(@Nonnull String messagingSystem) {
        switch (messagingSystem) {
            case "sns": 
            case "sqs": {
                return "aws." + messagingSystem;
            }
            case "google-pubsub": {
                return "gcp.pubsub";
            }
        }
        return messagingSystem;
    }

    @Override
    @Nonnull
    public String outboundOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".send";
    }

    @Override
    public String outboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return null;
    }

    @Override
    @Nonnull
    public String inboundOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".process";
    }

    @Override
    public String inboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return null;
    }

    @Override
    @Nonnull
    public String timeInQueueService(@Nonnull String messagingSystem) {
        return messagingSystem + "-queue";
    }

    @Override
    @Nonnull
    public String timeInQueueOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".deliver";
    }
}

