/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Config;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.util.CollectionUtils;
import ddtrot.dd.trace.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class DynamicConfig<S extends Snapshot> {
    static final Function<Map.Entry<String, String>, String> KEY = DynamicConfig::key;
    static final Function<Map.Entry<String, String>, String> VALUE = DynamicConfig::value;
    static final Function<Map.Entry<String, String>, String> LOWER_KEY = DynamicConfig::lowerKey;
    static final Function<Map.Entry<String, String>, String> REQUEST_TAG = DynamicConfig::requestTag;
    static final Function<Map.Entry<String, String>, String> RESPONSE_TAG = DynamicConfig::responseTag;
    BiFunction<Builder, S, S> snapshotFactory;
    S initialSnapshot;
    volatile S currentSnapshot;

    private DynamicConfig(BiFunction<Builder, S, S> snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
    }

    public static Builder create() {
        return new DynamicConfig<Snapshot>(Snapshot::new).new Builder();
    }

    public static <S extends Snapshot> Builder create(BiFunction<Builder, S, S> snapshotFactory) {
        return new DynamicConfig<S>(snapshotFactory).new Builder();
    }

    public S captureTraceConfig() {
        return this.currentSnapshot;
    }

    public Builder initial() {
        return new Builder((Snapshot)this.initialSnapshot);
    }

    public Builder current() {
        return new Builder((Snapshot)this.currentSnapshot);
    }

    public void resetTraceConfig() {
        this.currentSnapshot = this.initialSnapshot;
        DynamicConfig.reportConfigChange(this.initialSnapshot);
    }

    static Map<String, String> cleanMapping(Collection<? extends Map.Entry<String, String>> mapping, Function<Map.Entry<String, String>, String> keyMapper, Function<Map.Entry<String, String>, String> valueMapper) {
        HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
        for (Map.Entry<String, String> entry : mapping) {
            cleanedMapping.put(keyMapper.apply(entry), valueMapper.apply(entry));
        }
        return CollectionUtils.tryMakeImmutableMap(cleanedMapping);
    }

    static String key(Map.Entry<String, String> association) {
        return Strings.trim(association.getKey());
    }

    static String value(Map.Entry<String, String> association) {
        return Strings.trim(association.getValue());
    }

    static String lowerKey(Map.Entry<String, String> association) {
        return DynamicConfig.key(association).toLowerCase(Locale.ROOT);
    }

    static String requestTag(Map.Entry<String, String> association) {
        String requestTag = DynamicConfig.value(association);
        if (requestTag.isEmpty()) {
            requestTag = "http.request.headers." + Strings.normalizedHeaderTag(association.getKey());
        }
        return requestTag;
    }

    static String responseTag(Map.Entry<String, String> association) {
        String responseTag = DynamicConfig.value(association);
        if (responseTag.isEmpty()) {
            responseTag = "http.response.headers." + Strings.normalizedHeaderTag(association.getKey());
        }
        return responseTag;
    }

    static void reportConfigChange(Snapshot newSnapshot) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("trace.debug", newSnapshot.debugEnabled);
        update.put("runtime.metrics.enabled", newSnapshot.runtimeMetricsEnabled);
        update.put("logs.injection", newSnapshot.logsInjectionEnabled);
        update.put("data.streams.enabled", newSnapshot.dataStreamsEnabled);
        update.put("service.mapping", newSnapshot.serviceMapping);
        update.put("trace.request_header.tags", newSnapshot.requestHeaderTags);
        update.put("trace.response_header.tags", newSnapshot.responseHeaderTags);
        update.put("trace.header.baggage", newSnapshot.baggageMapping);
        DynamicConfig.maybePut(update, "trace.sample.rate", newSnapshot.traceSampleRate);
        ConfigCollector.get().putAll(update, ConfigOrigin.REMOTE);
    }

    private static void maybePut(Map<String, Object> update, String key, Object value) {
        if (null != value) {
            update.put(key, value);
        }
    }

    public static class Snapshot
    implements TraceConfig {
        final boolean debugEnabled;
        final boolean runtimeMetricsEnabled;
        final boolean logsInjectionEnabled;
        final boolean dataStreamsEnabled;
        final Map<String, String> serviceMapping;
        final Map<String, String> requestHeaderTags;
        final Map<String, String> responseHeaderTags;
        final Map<String, String> baggageMapping;
        final Double traceSampleRate;

        protected Snapshot(Builder builder, Snapshot oldSnapshot) {
            this.debugEnabled = builder.debugEnabled;
            this.runtimeMetricsEnabled = builder.runtimeMetricsEnabled;
            this.logsInjectionEnabled = builder.logsInjectionEnabled;
            this.dataStreamsEnabled = builder.dataStreamsEnabled;
            this.serviceMapping = Snapshot.nullToEmpty(builder.serviceMapping);
            this.requestHeaderTags = Snapshot.nullToEmpty(builder.requestHeaderTags);
            this.responseHeaderTags = Snapshot.nullToEmpty(builder.responseHeaderTags);
            this.baggageMapping = Snapshot.nullToEmpty(builder.baggageMapping);
            this.traceSampleRate = builder.traceSampleRate;
        }

        private static <K, V> Map<K, V> nullToEmpty(Map<K, V> mapping) {
            return null != mapping ? mapping : Collections.emptyMap();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return this.runtimeMetricsEnabled;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return this.logsInjectionEnabled;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return this.dataStreamsEnabled;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }

        @Override
        public Map<String, String> getRequestHeaderTags() {
            return this.requestHeaderTags;
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return this.responseHeaderTags;
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return this.baggageMapping;
        }

        @Override
        public Double getTraceSampleRate() {
            return this.traceSampleRate;
        }
    }

    public final class Builder {
        boolean debugEnabled;
        boolean runtimeMetricsEnabled;
        boolean logsInjectionEnabled;
        boolean dataStreamsEnabled;
        Map<String, String> serviceMapping;
        Map<String, String> requestHeaderTags;
        Map<String, String> responseHeaderTags;
        Map<String, String> baggageMapping;
        Double traceSampleRate;

        Builder() {
        }

        Builder(Snapshot snapshot) {
            this.debugEnabled = snapshot.debugEnabled;
            this.runtimeMetricsEnabled = snapshot.runtimeMetricsEnabled;
            this.logsInjectionEnabled = snapshot.logsInjectionEnabled;
            this.dataStreamsEnabled = snapshot.dataStreamsEnabled;
            this.serviceMapping = snapshot.serviceMapping;
            this.requestHeaderTags = snapshot.requestHeaderTags;
            this.responseHeaderTags = snapshot.responseHeaderTags;
            this.baggageMapping = snapshot.baggageMapping;
            this.traceSampleRate = snapshot.traceSampleRate;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setRuntimeMetricsEnabled(boolean runtimeMetricsEnabled) {
            this.runtimeMetricsEnabled = runtimeMetricsEnabled;
            return this;
        }

        public Builder setLogsInjectionEnabled(boolean logsInjectionEnabled) {
            this.logsInjectionEnabled = logsInjectionEnabled;
            return this;
        }

        public Builder setDataStreamsEnabled(boolean dataStreamsEnabled) {
            this.dataStreamsEnabled = dataStreamsEnabled;
            return this;
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            return this.setServiceMapping(serviceMapping.entrySet());
        }

        public Builder setHeaderTags(Map<String, String> headerTags) {
            if (Config.get().getRequestHeaderTags().equals(headerTags) && !Config.get().getResponseHeaderTags().equals(headerTags)) {
                this.requestHeaderTags = Config.get().getRequestHeaderTags();
                this.responseHeaderTags = Config.get().getResponseHeaderTags();
                return this;
            }
            return this.setHeaderTags(headerTags.entrySet());
        }

        public Builder setBaggageMapping(Map<String, String> baggageMapping) {
            return this.setBaggageMapping(baggageMapping.entrySet());
        }

        public Builder setServiceMapping(Collection<? extends Map.Entry<String, String>> serviceMapping) {
            this.serviceMapping = DynamicConfig.cleanMapping(serviceMapping, KEY, VALUE);
            return this;
        }

        public Builder setHeaderTags(Collection<? extends Map.Entry<String, String>> headerTags) {
            this.requestHeaderTags = DynamicConfig.cleanMapping(headerTags, LOWER_KEY, REQUEST_TAG);
            this.responseHeaderTags = DynamicConfig.cleanMapping(headerTags, LOWER_KEY, RESPONSE_TAG);
            return this;
        }

        public Builder setBaggageMapping(Collection<? extends Map.Entry<String, String>> baggageMapping) {
            this.baggageMapping = DynamicConfig.cleanMapping(baggageMapping, LOWER_KEY, VALUE);
            return this;
        }

        public Builder setTraceSampleRate(Double traceSampleRate) {
            this.traceSampleRate = traceSampleRate;
            return this;
        }

        public DynamicConfig<S> apply() {
            Object oldSnapshot = DynamicConfig.this.currentSnapshot;
            Snapshot newSnapshot = (Snapshot)DynamicConfig.this.snapshotFactory.apply(this, oldSnapshot);
            if (null == oldSnapshot) {
                DynamicConfig.this.initialSnapshot = newSnapshot;
                DynamicConfig.this.currentSnapshot = newSnapshot;
            } else {
                DynamicConfig.this.currentSnapshot = newSnapshot;
                DynamicConfig.reportConfigChange(newSnapshot);
            }
            return DynamicConfig.this;
        }
    }
}

