/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import datadog.trace.api.Config;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.common.socket.SocketUtils;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.TracerVersion;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCommunicationObjects {
    private static final Logger log = LoggerFactory.getLogger(SharedCommunicationObjects.class);
    public OkHttpClient okHttpClient;
    public HttpUrl agentUrl;
    public Monitoring monitoring;
    private DDAgentFeaturesDiscovery featuresDiscovery;
    private ConfigurationPoller configurationPoller;

    public void createRemaining(Config config) {
        if (this.monitoring == null) {
            this.monitoring = Monitoring.DISABLED;
        }
        if (this.agentUrl == null) {
            this.agentUrl = HttpUrl.parse(config.getAgentUrl());
            if (this.agentUrl == null) {
                throw new IllegalArgumentException("Bad agent URL: " + config.getAgentUrl());
            }
        }
        if (this.okHttpClient == null) {
            String unixDomainSocket = SocketUtils.discoverApmSocket(config);
            String namedPipe = config.getAgentNamedPipe();
            this.okHttpClient = OkHttpUtils.buildHttpClient(this.agentUrl, unixDomainSocket, namedPipe, SharedCommunicationObjects.getHttpClientTimeout(config));
        }
    }

    private static long getHttpClientTimeout(Config config) {
        if (!config.isCiVisibilityEnabled() || !config.isCiVisibilityAgentlessEnabled()) {
            return TimeUnit.SECONDS.toMillis(config.getAgentTimeout());
        }
        return config.getCiVisibilityBackendApiTimeoutMillis();
    }

    public ConfigurationPoller configurationPoller(Config config) {
        if (this.configurationPoller == null && config.isRemoteConfigEnabled()) {
            this.configurationPoller = this.createPoller(config);
        }
        return this.configurationPoller;
    }

    private ConfigurationPoller createPoller(Config config) {
        Supplier<String> configUrlSupplier;
        String containerId = ContainerInfo.get().getContainerId();
        String remoteConfigUrl = config.getFinalRemoteConfigUrl();
        if (remoteConfigUrl != null) {
            configUrlSupplier = new FixedConfigUrlSupplier(remoteConfigUrl);
        } else {
            this.createRemaining(config);
            configUrlSupplier = new RetryConfigUrlSupplier(this, config);
        }
        return new ConfigurationPoller(config, TracerVersion.TRACER_VERSION, containerId, (Supplier)configUrlSupplier, this.okHttpClient);
    }

    public void setFeaturesDiscovery(DDAgentFeaturesDiscovery featuresDiscovery) {
        this.featuresDiscovery = featuresDiscovery;
    }

    public DDAgentFeaturesDiscovery featuresDiscovery(Config config) {
        if (this.featuresDiscovery == null) {
            this.createRemaining(config);
            this.featuresDiscovery = new DDAgentFeaturesDiscovery(this.okHttpClient, this.monitoring, this.agentUrl, config.isTraceAgentV05Enabled(), config.isTracerMetricsEnabled());
            if (!"true".equalsIgnoreCase(System.getProperty("dd.test.no.early.discovery"))) {
                this.featuresDiscovery.discover();
            }
        }
        return this.featuresDiscovery;
    }

    private static final class RetryConfigUrlSupplier
    implements Supplier<String> {
        private String configUrl;
        private final SharedCommunicationObjects sco;
        private final Config config;

        private RetryConfigUrlSupplier(SharedCommunicationObjects sco, Config config) {
            this.sco = sco;
            this.config = config;
        }

        @Override
        public String get() {
            if (this.configUrl != null) {
                return this.configUrl;
            }
            DDAgentFeaturesDiscovery discovery = this.sco.featuresDiscovery(this.config);
            discovery.discoverIfOutdated();
            String configEndpoint = discovery.getConfigEndpoint();
            if (configEndpoint == null) {
                return null;
            }
            this.configUrl = discovery.buildUrl(configEndpoint).toString();
            log.debug("Found remote config endpoint: {}", (Object)this.configUrl);
            return this.configUrl;
        }
    }

    private static final class FixedConfigUrlSupplier
    implements Supplier<String> {
        private final String configUrl;

        private FixedConfigUrlSupplier(String configUrl) {
            this.configUrl = configUrl;
        }

        @Override
        public String get() {
            return this.configUrl;
        }
    }
}

